#if   !defined(__MAZE_HPP)
#define  __MAZE_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <Map.hpp>
#endif

#if   !defined(__ROOM_HPP)
#include <Room.hpp>
#endif


CORELINUX_MAP(  RoomNumber,  RoomPtr,  less<RoomNumber> ,  RoomMap );

DECLARE_CLASS( MazeBuilder );

DECLARE_CLASS( Maze );

/**
Maze is a collection of rooms connected by doors.
You can move through the maze in various directions
*/

class Maze
{

   friend   class MazeBuilder;

public:

   //
   // Constructors and destructor
   //

                        /// Default constructor starts with a room
            
                        Maze( RoomPtr aPtr );

                        /// Virtual destructor

   virtual              ~Maze( void );

   //
   // Operator overload
   //

            /// Equality, compares start room pointers

            bool  operator==( MazeCref ) const;

   //
   // Accessors
   //

            /// Get the starting room

            RoomCref    getStartLocation( void ) const;

            /// Get the current location

            RoomCref    getCurrentLocation( void ) const;

   //
   // Mutators
   //

            /// Change the location if possible

            void        walkInDirection( Direction );


protected:

   //
   // Constructors
   //

                        /// Default constructor not allowed

                        Maze( void ) throw( CORELINUX(Assertion) );

                        /// Copy constructor not allowed

                        Maze( MazeCref ) throw( CORELINUX(Assertion) );

   //
   // Operator overload
   //
            /// Assignment not allowed

            MazeRef  operator=( MazeCref ) throw( CORELINUX(Assertion) );

   //
   // Mutators
   //
            /// Add a room to the maze

            void        addRoom( RoomPtr );

            /// Get a room to manipulate

            RoomMapRef  getRooms( void );
private:

            RoomPtr     theStartRoom;
            RoomPtr     theCurrentRoom;
            Direction   theCurrentDirection;
            RoomMap     theRooms;
};

#endif // if   !defined(__MAZE_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.3 $
   $Date: 2000/08/31 22:50:31 $
   $Locker:  $
*/

