#if   !defined(__EVENTCONTEXT_HPP)
#define  __EVENTCONTEXT

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include    <corelinux/Common.hpp>
#endif

#if   !defined(__THREADCONTEXT_HPP)
#include    <corelinux/ThreadContext.hpp>
#endif

#if !defined(__EVENTSEMAPHOREGROUP_HPP)
#include  <corelinux/EventSemaphoreGroup.hpp>
#endif

typedef  Int (*ArgumentFunctionPtr)( CORELINUX(EventSemaphoreGroupPtr) );  

DECLARE_CLASS( EventContext )

/**
EventContext shows off how by extending ThreadContext we can add 
arguments to the call and use any method not just those prototyped
by the system. 
*/

class EventContext : public CORELINUX(ThreadContext)
{

public:

   //
   // Constructors and destructor
   //

                        /// Default Constructor

                        EventContext
                            ( 
                                ArgumentFunctionPtr, 
                                CORELINUX(EventSemaphoreGroupPtr) 
                            )
                            throw ( CORELINUX( Assertion ) );

                        /// With stack

                        EventContext
                           ( 
                              ArgumentFunctionPtr, 
                              CORELINUX(Size), 
                              CORELINUX(EventSemaphoreGroupPtr)
                           )
                           throw ( CORELINUX( Assertion ) );

                        /// Copy constructor

                        EventContext( EventContextCref )
                           throw ( CORELINUX( Assertion ) );

                        /// Virtual destructor

   virtual              ~EventContext( void );

   //
   // Operator overloads
   //

            /**
            Assignment operator changes the context
            @param EventContext reference to existing context
            @return EventContext reference
            @exception ThreadNotWaitingException if the
            Event context is not in a THREAD_WAITING_TO_START
            state.
            */
         
            EventContextRef  operator=( EventContextCref )
               throw( CORELINUX( Assertion ) );
         

            /**
            Equality operator compares contexts
            @param EventContext reference to existing context
            @return bool true if same
            */
         
            bool  operator==( EventContextCref ) const;

   //
   // Accessors
   //

            /// Return the argument to the caller

            CORELINUX(EventSemaphoreGroupPtr) getArgument( void ) const;   


   //
   // Mutators
   //

            /// Sets the argument after initialization

            void  setArgument( CORELINUX(EventSemaphoreGroupPtr) ) ;


protected:

   //
   // Constructor
   //

                        /// Can't use!

                        EventContext( void )
                           throw ( CORELINUX( Assertion ) );

   //
   // Accessor
   //
            /// Return the function to invoke

            ArgumentFunctionPtr    getArgumentFunction( void );

private:

               /**
               The default allocation routine for the managers ThreadContext.
               The copy constructor is called with the argument reference
               @param ThreadContext reference to the context supplied in the
               startThread method.
               @return The newly allocated managed context
               */

      static   CORELINUX(ThreadContextPtr)  argumentContextCreate
                  ( 
                     CORELINUX(ThreadContextRef) 
                  );

               /**
               The default destroyer of managed ThreadContexts.
               @param ThreadContext pointer to managed object.
               */

      static   void  argumentContextDestroy( CORELINUX(ThreadContextPtr) );

      static   Int  argumentFrame( CORELINUX(ThreadContextPtr) );


private:

            /// The callers argument

            CORELINUX(EventSemaphoreGroupPtr)   theSemaphoreGroup;
};


#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/09/10 04:37:32 $
   $Locker:  $
*/

