/*  mktlin.unx
    Copyright (C) Dr. Claudia Neumann

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this software; see the file COPYING.   If not, write to
  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
  Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 
   Contact: Dr. Claudia Neumann
                 Herderstr. 7
                 D - 26169 Friesoythe

                 dr. claudia.neumann@gmx.de

   This is a program to read the german "Krankenversichertenkarte" 
   (KVK)  und the german "elektronische Gesundheitskarte" (eGK) with card readers on
   the serial port by using the libctapi-mkt

   See documentations under http://www.kbv.de/ita/register_G.html and 
   http://www.gematik.de/upload/gematik_Qop_eGK_Spezifikation_Teil1_V1_1_0_Kommentare_4_1652.pdf 

   It works with:
     Kernel > 2.6.0
     tested on various card readers that are certified from the KBV with KVK,
     KVK and eGK tested on Celectronic CardStar medic2, Thales medCompact.

   Report bugs or comments to:
        dr.claudia.neumann@gmx.de

   Known Bugs:
      none (hopefully) ;-)

*/

#include "ctapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>



int main(int argc, char **argv) {
  short rv;
  unsigned char resetct[] = {0x20, 0x11, 0x00, 0x00, 0x00};
  unsigned char requicc[] = {0x20, 0x12, 0x01, 0x00, 0x01, 0x01};
//  unsigned char requicc[] = {0x20, 0x12, 0x01, 0x01, 0x00};
  unsigned char selfile[] =  {0x00, 0xA4, 0x04, 0x00, 0x06, 0xD2, 0x76, 0x00, 0x00, 0x01, 0x01};
  unsigned char rbkvk[] = {0x00, 0xB0, 0x00, 0x00, 0x00};
  unsigned char rbegk[] ={0x00, 0xB0, 0x81, 0x00, 0x00};
  unsigned char sbf[] = {0x00};
  unsigned char ejecticc[] = {0x20, 0x15, 0x01, 0x00, 0x00};
  unsigned char erase[] = {0x00, 0x0E, 0x00, 0x00};
  unsigned char dad;
  unsigned char sad;
  unsigned char response[300];
  unsigned char cpd[850];
  unsigned char cvd[1250];
  unsigned char ckvk[300];
  char ffile[300];
  unsigned short lenr;
  int x , y, z, nl, nm, npd, nvd1, nvd2, mobil, ncard, tst, nl2,ctn,pn;
  FILE *fz;

  tst=1;  // Alle Meldungen = 1

  if (argc<2) {
      fprintf(stdout,"richtiger Gebrauch: %s <Port-Nr.> <Dateiname>\n", argv[0]);
      return 2;
  }

  ctn=atoi(argv[1]);
  pn=ctn; 
  rv=CT_init(ctn, pn);
  if (rv) {
    fprintf(stdout, "Unable to init device\n");
    return 2;
  }
  else {
    if (tst){
     fprintf(stdout, "Device-Initialisierung erfolgreich\n");
    }
    }

/***Reset CT  */
  dad=1;
  sad=2;
  if (tst) {
  printf("Reset CT\n");
  printf("CMD: ");
  for(x=0;x<5;x++){
     printf("%02x ",resetct[x]);
     }
    printf("\n");
    }
  memset (response, 0x00, 300);
  lenr=sizeof(response);
  rv=CT_data(ctn, &dad, &sad, 5, resetct, &lenr, response);
  if (rv) {
    fprintf(stdout, "Error in Reset CT: (%d)\n", rv);
    return 2;
  }
  if (lenr<2) {
    fprintf(stdout, "Response too short (Reset CT) (%d)\n", lenr);
    return 2;
  }

  if (tst) {
  printf("RSP: ");
  for(x=0;x<lenr;x++){
    printf("%02x ",response[x]);
     }
    printf("\n");
    }
    if ( (response[lenr-2]==0x64) && (response[lenr-1]==0x00) ) {
      fprintf(stdout, "Reset CT nicht erfolgreich\n");
      return 2;
    }
    if ( (response[lenr-2]==0x90) && (response[lenr-1]==0x00) ) {
      if (tst) {
      fprintf(stdout, "Reset CT erfolgreich, stationaeres Lesegeraet\n");
      }
      mobil=0;
    }
    else if ( (response[lenr-2]==0x95) && (response[lenr-1]==0x00) ) {
      if (tst) {
      fprintf(stdout, "Reset CT erfolgreich, mobiles Lesegeraet\n");
      }
      mobil=1;
    }
    else {
      fprintf(stdout, "Reset CT misslungen\n");
      return 2;
    }

/***Request ICC */
  dad=1;
  sad=2;
  if (tst) {
  printf("Request ICC\n");
  printf("CMD: ");
  for(x=0;x<sizeof(requicc);x++){
     printf("%02x ",requicc[x]);
     }
    printf("\n");
  }  
  memset (response, 0x00, 300);
  lenr=sizeof(response);
  rv=CT_data(ctn, &dad, &sad, sizeof(requicc), requicc, &lenr, response);
  if (rv) {
    fprintf(stdout, "Error in command: Request ICC (%d)\n", rv);
    return 2;
  }
  if (lenr<2) {
    fprintf(stdout, "Response too short: Request ICC (%d)\n", lenr);
    return 2;
  }
  if (tst) {
  printf("RSP: ");
  for(x=0;x<lenr;x++){
    printf("%02x ",response[x]);
   }
   printf("\n");
   }
   if ( (response[lenr-2]==0x62) && (response[lenr-1]==0x00) ) {
    fprintf(stdout, "Keine Karte gelesen, Lese-Timeout\n");
    return 2;
    }
   if ( (response[lenr-2]==0x64) && (response[lenr-1]==0x00) ) {
    fprintf(stdout, "Reset ICC misslungen\n");
    return 2;
    }
   if  (response[lenr-2]==0x90) {
     if (response[lenr-1]==0x00)  {
           fprintf(stdout, "KVK\n");
           ncard=1;
       }
    if (response[lenr-1]==0x01) {
           fprintf(stdout, "eGK\n");
           ncard=2;
       }
    if (mobil) {
      fprintf(stdout,"mobil\n");
      }
    }
   else {
       fprintf(stdout, "Request ICC misslungen\n");
       return 2;
       }

/***Select File */
  dad=0;
  sad=2;
  if (ncard==2) {
    selfile[3]=0x0C;
    selfile[10]=0x02;
    }
  if (tst) {
  printf("Select File\n");
  printf("CMD: ");
  for(x=0;x<11;x++){
     printf("%02x ",selfile[x]);
     }
    printf("\n");
  }
  memset (response, 0x00, 300);
  lenr=sizeof(response);
  rv=CT_data(ctn, &dad, &sad, 11, selfile, &lenr, response);
  if (rv) {
    fprintf(stdout, "Error in command: Select File (%d)\n", rv);
    return 2;
  }
  if (lenr<2) {
    fprintf(stdout, "Response too short: Select File (%d)\n", lenr);
    return 2;
  }
  if (tst) {
  printf("RSP: ");
  for(x=0;x<lenr;x++){
     printf("%02x ",response[x]);
     }
    printf("\n");
  }
  if ( (response[lenr-2]==0x6A) && (response[lenr-1]==0x82) ) {
       fprintf(stdout, "Select File: Application not found\n");
       return 2;
     }
   if ( (response[lenr-2]==0x90) && (response[lenr-1]==0x00) ) {
       if (tst) {
         fprintf(stdout, "Command successful\n");
         }
     }
     else {
       fprintf(stdout, "Select File: unbekannter Fehler\n");
       return 2;
       }


/***Read Binary */
  dad=0;
  sad=2;
  nl=0;
  if (ncard==1) {    // KVK
  if (tst) {
  printf("Read Binary\n");
  }
  for(y=1;y<11;y++) {
   if (tst) {
    printf("CMD: ");
    for(x=0;x<5;x++){
      printf("%02x ",rbkvk[x]);
      }
     printf("\n");
    }
    memset (response, 0x00, 300);
    lenr=sizeof(response);
    rv=CT_data(ctn, &dad, &sad, 5, rbkvk, &lenr, response);
    if (rv) {
      fprintf(stdout, "Error in command: Read Binary (%d)\n", rv);
      return 2;
      }
    if (lenr<2) {
    fprintf(stdout, "Response too short: Read Binary (%d)\n", lenr);
    return 2;
      }
    if (tst) {
    printf("RSP: ");
    for(x=0;x<lenr;x++){
      printf("%02x ",response[x]);
      }
    printf("\n");
    }
    if ( (response[lenr-2]==0x65) && (response[lenr-1]==0x01) ) {
      fprintf(stdout,"Memory failure or data corrupted\n") ;
      return 2;
      }
    if ( (response[lenr-2]==0x6B) && (response[lenr-1]==0x00) ) {
      fprintf(stdout,"Wrong offset\n") ;
      return 2;
      }
     if ( ( (response[lenr-2]==0x62) && (response[lenr-1]==0x82) ) || ( (response[lenr-2]==0x90) && (response[lenr-1]==0x00) ) ) {
      if (tst) {
      fprintf(stdout,"Command successful\n") ;
      }
      for(x=0;x<lenr;x++){
        ckvk[nl++]=response[x];
      }
      break;
    }
    else {
     fprintf(stdout,"Anderer Fehler: Read Binary\n") ;
      return 2;
      }
      }
      if (tst) {
     for(x=0;x<=nl;x++) {
       if (ckvk[x]<32 || ckvk[x]>126) {
         fprintf(stdout," ");
         }
      else {
        fprintf(stdout,"%c",ckvk[x]);
        }
      }
      printf("\n"); 
      }

     fz=fopen(argv[2],"w");
      if (fz==NULL) {
        fprintf(stdout,"Fehler beim ffnen der Datei %s\n", argv[2]);
        }
      if (fwrite( ckvk, nl, 1, fz) != 1) {
        fprintf(stdout, "Fehler beim Schreiben in Datei %s\n", argv[1]);
        }
     fclose(fz);
   }


  if (ncard==2) {   // eGK
    z=0;
    nm=0;
    memset ( cpd, 0x00, sizeof(cpd));
    memset ( cvd, 0x00, sizeof(cvd));

    if (tst) {
    printf("Read Binary\n");
    printf("\nPatientendaten:\n");
    }
    for(y=1;y<11;y++) {

    if (tst) {
    printf("CMD: ");     //  PD
    for(x=0;x<5;x++){
     printf("%02x ",rbegk[x]);
     }
    printf("\n");
    }
    memset (response, 0x00, 300);
    lenr=sizeof(response);
    rv=CT_data(ctn, &dad, &sad, 5, rbegk, &lenr, response);
    if (rv) {
      fprintf(stdout, "Error in command: Read Binary(%d)\n", rv);
      return 2;
      }
    if (lenr<2) {
      fprintf(stdout, "Response too short: Read Binary (%d)\n", lenr);
      return 2;
      }

    if (tst) {
    printf("RSP: ");
    for(x=0;x<lenr;x++){
      printf("%02x ",response[x]);
      }
    printf("\n");
    printf("response[1]=%02x\n",response[1]);
 
    }
  if ( (response[lenr-2]==0x90) && (response[lenr-1]==0x00) ) {
      if (tst) {
      fprintf(stdout,"Command successful\n") ;
      }
      if (y==1) {
       npd=response[0]*0x100+response[1];
       for(x=2;x<lenr-2;x++){
         cpd[nl++]=response[x];
         }
        } 
      else {
        for(x=0;x<lenr-2;x++){
          cpd[nl++]=response[x];
          }
        }        
      z++;
      }	
     else {
      fprintf(stdout,"Fehler beim Auslesen der eGK\n");
      return 2;
     }
    nm=256*z;
    if (nm>=npd){
    break;
    }
    else {
    rbegk[2]=z;
    dad=0;
    sad=2;
    }
    }
    if (tst) {
    printf("\n");
    printf("Ausgabe cpd:\n");
    for(x=0;x<=npd;x++){
    printf("%02x ", cpd[x]);
    }
    printf("\n\n");
    }

    strcat( strcpy( ffile, argv[2]), "_pd.gz");
    fz=fopen( ffile,"w");
    if (fz==NULL) {
     fprintf(stdout,"Fehler beim ffnen der Datei %s\n", ffile);
     }
    if (fwrite(cpd, npd, 1, fz) != 1) {
      fprintf(stdout, "Fehler beim Schreiben in Datei %s!\n", ffile);
    }
    fclose(fz);

 
    if (tst) {
    fprintf(stdout,"\nVersicherungsdaten:\n");
    }
    rbegk[2]=0x82;
    nl=0;
    nm=0;
    z=0;
    dad=0;
    sad=2;
    for(y=1;y<11;y++) {
    
    if (tst) {
    printf("CMD: ");  //  VD
    for(x=0;x<5;x++){
     printf("%02x ",rbegk[x]);
     }
    printf("\n");
    }
    memset (response, 0x00, 300);
    lenr=sizeof(response);
    rv=CT_data(ctn, &dad, &sad, 5, rbegk, &lenr, response);
    if (rv) {
      fprintf(stdout, "Error in command: Read Binary (%d)\n", rv);
      return 2;
      }
    if (lenr<2) {
      fprintf(stdout, "Response too short: Read Binary (%d)\n", lenr);
      return 2;
      }

    if (tst) {
    printf("RSP: ");
    for(x=0;x<lenr;x++){
      printf("%02x ",response[x]);
      }
    printf("\n");
    }

    if ( (response[lenr-2]==0x90) && (response[lenr-1]==0x00) ) {
      if (tst) {
      fprintf(stdout,"Command successful\n") ;
      }
      if (y==1) {
      nvd1=response[2]*0x100+response[3];
      nvd2=response[6]*0x100+response[7];
      for(x=8;x<lenr-2;x++){
           cvd[nl++]=response[x];
           }
        }
      else {
        for(x=0;x<lenr-2;x++){
          cvd[nl++]=response[x];
          }
        }
      z++;
      if (nl>=nvd2){
        break;
        }
      }
     else {
      fprintf(stdout,"Fehler beim Auslesen der eGK\n");
      return 2;
      }
      rbegk[2]=z;
      dad=0;
      sad=2;
      }
    if (tst) {
    printf("\n");
    printf("Ausgabe cvd:\n");
    for(z=0;z<=nvd2;z++){
    printf("%02x ", cvd[z]);
    }
    printf("\n");
    printf("nvd2 = %d\n",nvd2);
    }
    strcat( strcpy( ffile, argv[2]), "_vd.gz");
    fz=fopen( ffile,"w");
    if (fz==NULL) {
      printf("Fehler beim Oeffnen der Datei %s\n", ffile);
      }
    if (fwrite(cvd, nvd2, 1, fz) != 1) {
      fprintf(stdout, "Fehler beim Schreiben in Datei %s!\n", ffile);
    }
    fclose(fz);
  }     


  rv=CT_close(ctn);
  if (rv) {
    fprintf(stdout, "Unable to close device\n");
    return 2;
  }

  return 0;
}



