/* 
 * $Id: ctkcontainer.c,v 1.21 2000/07/13 01:02:49 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include "ctk.h"

/* initialize a container */
void ctk_container_init(CtkContainer *container)
{
	/* Initialize Widget Structure */	
	ctk_widget_init(&container->widget);
	
	/* Initialize Signals */
	ctk_signal_new("check_resize",CtkTypeContainer);

	container->border_width = 0;
	container->set_child_flags = &ctk_container_set_default_child_flags;
	container->lost_child      = NULL;
	container->last = NULL;
}

void ctk_container_set_default_child_flags(CtkContainer* container, CtkWidget* child)
{
	/* By default a container doesn't change the child */
}

/* Add a widget to a container */
void ctk_container_add(CtkContainer* container, CtkWidget* widget)
{
	GNode* node;
	
	if (!container)
	{
		ctk_close();
		g_error("ctk_container_add: CtkContainer *container == NULL");
	}

	if (!widget)
	    return;
	    
	(*container->set_child_flags)(container, widget);
	
	node = widget->node;
	
	if (container->last)
	{
		node->prev       = container->last;
		node->prev->next = node;
		node->parent     = CTK_WIDGET(container)->node;
		
		container->last = node;
	}
	else
	{
		g_node_append(CTK_WIDGET(container)->node, node);
		container->last = node;
	}
	
	ctk_size_mark_changed(widget);
}

void ctk_container_remove(CtkContainer* container, CtkWidget* widget)
{
	GNode*     child_node;
	CtkWindow* window;
	
	if (!container || !widget)
	    return;
	
	/* Remove the focus on this item */
	window = ctk_window_container(widget);
	if (window)
	{
		/* Does our windows focused widget have packing through
		 * this node? If so, reset the focus.
		 */
		 
		GNode* scan;
		
		for (scan = window->focus_widget->node; scan; scan = scan->parent)
		{
			if (scan == widget->node)
			{
				/* The focused widget is in the thing we're
				 * unpacking so unfocus!
				 */
				ctk_window_set_focus(window, CTK_WIDGET(window));
			}
		}
	}
	
	child_node = widget->node;
	if (!child_node || child_node->parent != CTK_WIDGET(container)->node)
		return;
		
	if (container->last == child_node)
		container->last = child_node->prev;
	
	g_node_unlink(child_node);
	
	ctk_size_mark_changed(CTK_WIDGET(container));
	
	if (container->lost_child)
		(*container->lost_child)(container, widget);
}

void ctk_container_set_border_width(CtkContainer* container,
				   gint border_width)
{
	if (!container)
	    return;

	if (border_width < 0)
	    border_width = 0;
	
	container->border_width = border_width;
	
	ctk_size_mark_changed(CTK_WIDGET(container));
}
