/* 
 * $Id: ctkhbox.c,v 1.8 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>

#include "ctk.h"
#include "ctkbox.h"

void ctk_hbox_init(CtkHBox* hbox, gboolean homogeneous, gint spacing)
{
	if (spacing < 0)
		spacing = 0;

	ctk_box_init(&hbox->box, 1, 0, homogeneous);

	((CtkObject *)hbox)->type = CtkTypeHBox;
	
	ctk_table_set_col_spacings(CTK_TABLE(hbox), spacing);

	((CtkBox*)hbox)->pack_start = &ctk_hbox_pack_start;
	((CtkBox*)hbox)->pack_end   = &ctk_hbox_pack_end;
}

/* CTK HBOX New */
CtkWidget* ctk_hbox_new(gboolean homogeneous, gint spacing)
{
	CtkHBox *hbox;

	hbox = g_malloc(sizeof(CtkHBox));

	ctk_hbox_init(hbox, homogeneous, spacing);

	return (CtkWidget *)hbox;
}

void ctk_hbox_pack_start(CtkBox* box, CtkWidget* child, gboolean expand, gboolean fill, gint padding)
{
	CtkTable* table   = CTK_TABLE(box);
	gint      options = 0;
	
	if (expand) options |= CTK_EXPAND;
	if (fill)   options |= CTK_FILL;
	
	ctk_table_insert_col(table, box->pack_index);
	
	ctk_table_attach(table, child, box->pack_index, box->pack_index+1, 0, 1, options, CTK_EXPAND|CTK_FILL, padding, 0);
	box->pack_index++;
}

void ctk_hbox_pack_end(CtkBox* box, CtkWidget* child, gboolean expand, gboolean fill, gint padding)
{
	CtkTable* table   = CTK_TABLE(box);
	gint      options = 0;
	
	if (expand) options |= CTK_EXPAND;
	if (fill)   options |= CTK_FILL;
	
	ctk_table_insert_col(table, box->pack_index);
	
	ctk_table_attach(table, child, box->pack_index, box->pack_index+1, 0, 1, options, CTK_EXPAND|CTK_FILL, padding, 0);
}
