/* 
 * $Id: ctkio.h,v 1.6 2000/07/27 03:23:46 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __IO_MON_H__
#define __IO_MON_H__

/* IO Defines */
/*typedef enum {
	CTK_IO_IN GLIB_SYSDEF_POLLIN,
	CTK_IO_OUT GLIB_SYSDEF_POLLOUT
} CtkInputCondition; */

typedef enum {
	CTK_INPUT_READ = 1 << 0,
	CTK_INPUT_WRITE = 1 << 1,
	CTK_INPUT_EXCEPTION = 1 << 2
} CtkInputCondition;

typedef void (*CtkInputFunction) (gpointer data,
				  gint source,
				  CtkInputCondition condition);

/* IO Monitoring functions */
guint ctk_input_add (gint fd, CtkInputCondition condition, gpointer function, gpointer data);
void ctk_input_remove(guint tag);

guint ctk_timeout_add(guint32 interval, gpointer function, gpointer data);
void  ctk_timeout_remove(guint tag);

#endif
