/* 
 * $Id: ctkmisc.c,v 1.8 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the misc */
void ctk_misc_init(CtkMisc* misc)
{
	ctk_widget_init(&misc->widget);
	
	CTK_OBJECT(misc)->type = CtkTypeMisc;

	misc->xalign = 0.5;
	misc->yalign = 0.5;
	misc->xpad = 0;
	misc->ypad = 0;
}

/* Set Alignment */
void
    ctk_misc_set_alignment(CtkMisc *misc, gfloat xalign, gfloat yalign)
{
	
	if (!misc)
	    return;
	
	if (xalign < 0)
	    xalign = 0;
	else if (xalign > 1)
	    xalign = 1;
	
	if (yalign < 0)
	    yalign = 0;
	else if (yalign > 1)
	    yalign = 1;
	
	misc->xalign = xalign;
	misc->yalign = yalign;
}

/* Set padding */
void
    ctk_misc_set_padding(CtkMisc *misc, gint xpad, gint ypad)
{
	
	if (!misc)
	    return;
	
	if (xpad < 0)
	    xpad = 0;
	if (ypad < 0)
	    ypad = 0;
	
	misc->xpad = xpad;
	misc->ypad = ypad;
}
