/* desktop-entry-impl-glib.c generated by valac 0.10.4, the Vala compiler
 * generated from desktop-entry-impl-glib.vala, do not modify */

/*
 * Desktop Agnostic Library: Desktop Entry implementation using GLib.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/fdo.h>
#include <libdesktop-agnostic/vfs.h>


#define DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB (desktop_agnostic_fdo_desktop_entry_glib_get_type ())
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB, DesktopAgnosticFDODesktopEntryGLib))
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB, DesktopAgnosticFDODesktopEntryGLibClass))
#define DESKTOP_AGNOSTIC_FDO_IS_DESKTOP_ENTRY_GLIB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB))
#define DESKTOP_AGNOSTIC_FDO_IS_DESKTOP_ENTRY_GLIB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB))
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB, DesktopAgnosticFDODesktopEntryGLibClass))

typedef struct _DesktopAgnosticFDODesktopEntryGLib DesktopAgnosticFDODesktopEntryGLib;
typedef struct _DesktopAgnosticFDODesktopEntryGLibClass DesktopAgnosticFDODesktopEntryGLibClass;
typedef struct _DesktopAgnosticFDODesktopEntryGLibPrivate DesktopAgnosticFDODesktopEntryGLibPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))

struct _DesktopAgnosticFDODesktopEntryGLib {
	GObject parent_instance;
	DesktopAgnosticFDODesktopEntryGLibPrivate * priv;
};

struct _DesktopAgnosticFDODesktopEntryGLibClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticFDODesktopEntryGLibPrivate {
	GKeyFile* _keyfile;
	gboolean loaded;
	DesktopAgnosticVFSFile* _file;
};


static gpointer desktop_agnostic_fdo_desktop_entry_glib_parent_class = NULL;
static DesktopAgnosticFDODesktopEntryIface* desktop_agnostic_fdo_desktop_entry_glib_desktop_agnostic_fdo_desktop_entry_parent_iface = NULL;

#define DESKTOP_AGNOSTIC_FDO_GROUP "Desktop Entry"
GType desktop_agnostic_fdo_desktop_entry_glib_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB, DesktopAgnosticFDODesktopEntryGLibPrivate))
enum  {
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_FILE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_KEYFILE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_DATA,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ENTRY_TYPE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_NAME,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ICON
};
static gboolean desktop_agnostic_fdo_desktop_entry_glib_real_key_exists (DesktopAgnosticFDODesktopEntry* base, const char* key);
static gboolean desktop_agnostic_fdo_desktop_entry_glib_real_get_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_glib_real_set_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key, gboolean value);
static char* desktop_agnostic_fdo_desktop_entry_glib_real_get_string (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_glib_real_set_string (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* value);
static char* desktop_agnostic_fdo_desktop_entry_glib_real_get_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale);
static void desktop_agnostic_fdo_desktop_entry_glib_real_set_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale, const char* value);
static char** desktop_agnostic_fdo_desktop_entry_glib_real_get_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_glib_real_set_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key, char** value);
static gboolean desktop_agnostic_fdo_desktop_entry_glib_real_exists (DesktopAgnosticFDODesktopEntry* base);
static char* desktop_agnostic_fdo_desktop_entry_glib_get_quoted_word (DesktopAgnosticFDODesktopEntryGLib* self, const char* word, gboolean in_single_quotes, gboolean in_double_quotes);
static char* desktop_agnostic_fdo_desktop_entry_glib_do_percent_subst (DesktopAgnosticFDODesktopEntryGLib* self, const char* code, GSList* documents, gboolean in_single_quotes, gboolean in_double_quotes);
static char* desktop_agnostic_fdo_desktop_entry_glib_parse_exec (DesktopAgnosticFDODesktopEntryGLib* self, GSList* documents);
static GPid desktop_agnostic_fdo_desktop_entry_glib_do_app_launch (DesktopAgnosticFDODesktopEntryGLib* self, const char* working_dir, GSpawnFlags flags, GSList* documents, GError** error);
static GPid desktop_agnostic_fdo_desktop_entry_glib_real_launch (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryLaunchFlags flags, GSList* documents, GError** error);
static void _g_slist_free_g_free (GSList* self);
static void desktop_agnostic_fdo_desktop_entry_glib_real_save (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* new_file, GError** error);
DesktopAgnosticFDODesktopEntryGLib* desktop_agnostic_fdo_desktop_entry_glib_new (void);
DesktopAgnosticFDODesktopEntryGLib* desktop_agnostic_fdo_desktop_entry_glib_construct (GType object_type);
static void desktop_agnostic_fdo_desktop_entry_glib_finalize (GObject* obj);
static void desktop_agnostic_fdo_desktop_entry_glib_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_fdo_desktop_entry_glib_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType register_plugin (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean desktop_agnostic_fdo_desktop_entry_glib_real_key_exists (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_val_if_fail (key != NULL, FALSE);
	if (g_key_file_has_group (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP)) {
		gboolean _tmp1_;
		_tmp1_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean desktop_agnostic_fdo_desktop_entry_glib_real_get_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_;
		_tmp0_ = g_key_file_get_boolean (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-glib.vala:204: Error trying to retrieve '%s': %s", key, err->message);
			result = FALSE;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally0:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key, gboolean value) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, value);
}


static char* desktop_agnostic_fdo_desktop_entry_glib_real_get_string (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	char* result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_val_if_fail (key != NULL, NULL);
	{
		char* _tmp0_;
		_tmp0_ = g_key_file_get_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-glib.vala:224: Error trying to retrieve '%s': %s", key, err->message);
			result = NULL;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally1:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_string (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* value) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	g_key_file_set_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, value);
}


static char* desktop_agnostic_fdo_desktop_entry_glib_real_get_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	char* result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_val_if_fail (key != NULL, NULL);
	{
		char* _tmp0_;
		_tmp0_ = g_key_file_get_locale_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, locale, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-glib.vala:244: Error trying to retrieve '%s[%s]': %" \
"s", key, locale, err->message);
			result = NULL;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally2:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale, const char* value) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_if_fail (key != NULL);
	g_return_if_fail (locale != NULL);
	g_return_if_fail (value != NULL);
	g_key_file_set_locale_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, locale, value);
}


static char** desktop_agnostic_fdo_desktop_entry_glib_real_get_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	char** result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_val_if_fail (key != NULL, NULL);
	{
		gint _tmp1__length1;
		gint __tmp1__size_;
		char** _tmp2_;
		gsize _tmp0_;
		char** _tmp1_;
		_tmp1_ = (_tmp2_ = g_key_file_get_string_list (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, &_tmp0_, &_inner_error_), _tmp1__length1 = _tmp0_, __tmp1__size_ = _tmp1__length1, _tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp1_;
		return result;
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("desktop-entry-impl-glib.vala:266: Error trying to retrieve '%s': %s", key, err->message);
			result = NULL;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally3:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key, char** value) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	g_return_if_fail (key != NULL);
	g_key_file_set_string_list (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, key, (const gchar* const*) value, _vala_array_length (value));
}


/**
     * Based on EggDesktopFile's egg_desktop_file_can_launch().
     */
static gboolean desktop_agnostic_fdo_desktop_entry_glib_real_exists (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	switch (desktop_agnostic_fdo_desktop_entry_get_entry_type ((DesktopAgnosticFDODesktopEntry*) self)) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION:
		{
			gboolean _tmp0_;
			char* exec;
			gint argv_length1;
			gint _argv_size_;
			char** _tmp4_;
			char** argv;
			char* _tmp5_;
			gboolean _tmp6_ = FALSE;
			char* _tmp8_;
			gboolean _tmp9_;
			_tmp0_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "TryExec", &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp0_) {
				char* _tmp1_;
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = (_tmp2_ = g_find_program_in_path (_tmp1_ = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "TryExec"))) != NULL, _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_)) {
					result = TRUE;
					return result;
				}
			}
			exec = NULL;
			argv = (_tmp4_ = NULL, argv_length1 = 0, _argv_size_ = argv_length1, _tmp4_);
			;
			exec = (_tmp5_ = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Exec"), _g_free0 (exec), _tmp5_);
			if (exec == NULL) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = g_shell_parse_argv (exec, &argv_length1, &argv, &_inner_error_);
				if (_inner_error_ != NULL) {
					argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (exec);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_tmp6_ = !_tmp7_;
			}
			if (_tmp6_) {
				result = FALSE;
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (exec);
				return result;
			}
			result = (_tmp9_ = (_tmp8_ = g_find_program_in_path (argv[0])) != NULL, _g_free0 (_tmp8_), _tmp9_);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exec);
			return result;
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exec);
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK:
		{
			gboolean _tmp10_;
			_tmp10_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "URL", &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp10_) {
				char* uri;
				DesktopAgnosticVFSFile* file;
				uri = g_key_file_get_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "URL", &_inner_error_);
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				file = desktop_agnostic_vfs_file_new_for_uri (uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				result = desktop_agnostic_vfs_file_exists (file);
				_g_object_unref0 (file);
				_g_free0 (uri);
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


/**
     * Ported from EggDesktopFile.
     */
static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* desktop_agnostic_fdo_desktop_entry_glib_get_quoted_word (DesktopAgnosticFDODesktopEntryGLib* self, const char* word, gboolean in_single_quotes, gboolean in_double_quotes) {
	char* result = NULL;
	char* _result_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (word != NULL, NULL);
	_result_ = g_strdup ("");
	if (!in_single_quotes) {
		_tmp0_ = !in_double_quotes;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		_result_ = (_tmp1_ = g_strconcat (_result_, "'", NULL), _g_free0 (_result_), _tmp1_);
	} else {
		gboolean _tmp2_ = FALSE;
		if (!in_single_quotes) {
			_tmp2_ = in_double_quotes;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			char* _tmp3_;
			_result_ = (_tmp3_ = g_strconcat (_result_, "\"'", NULL), _g_free0 (_result_), _tmp3_);
		}
	}
	if (string_contains (word, "'")) {
		{
			char* s;
			s = g_strdup (word);
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_ = FALSE;
					char* chr;
					if (!_tmp4_) {
						char* _tmp5_;
						s = (_tmp5_ = g_strdup (g_utf8_next_char (s)), _g_free0 (s), _tmp5_);
					}
					_tmp4_ = FALSE;
					if (s != NULL) {
						_tmp6_ = g_utf8_strlen (s, -1) > 0;
					} else {
						_tmp6_ = FALSE;
					}
					if (!_tmp6_) {
						break;
					}
					chr = string_substring (s, (glong) 0, (glong) 1);
					if (_vala_strcmp0 (chr, "'") == 0) {
						char* _tmp7_;
						_result_ = (_tmp7_ = g_strconcat (_result_, "'\\''", NULL), _g_free0 (_result_), _tmp7_);
					} else {
						char* _tmp8_;
						_result_ = (_tmp8_ = g_strconcat (_result_, chr, NULL), _g_free0 (_result_), _tmp8_);
					}
					_g_free0 (chr);
				}
			}
			_g_free0 (s);
		}
	} else {
		char* _tmp9_;
		_result_ = (_tmp9_ = g_strconcat (_result_, word, NULL), _g_free0 (_result_), _tmp9_);
	}
	if (!in_single_quotes) {
		_tmp10_ = !in_double_quotes;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		char* _tmp11_;
		_result_ = (_tmp11_ = g_strconcat (_result_, "'", NULL), _g_free0 (_result_), _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		if (!in_single_quotes) {
			_tmp12_ = in_double_quotes;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			char* _tmp13_;
			_result_ = (_tmp13_ = g_strconcat (_result_, "'\"", NULL), _g_free0 (_result_), _tmp13_);
		}
	}
	result = _result_;
	return result;
}


/**
     * Ported from EggDesktopFile.
     */
static char* desktop_agnostic_fdo_desktop_entry_glib_do_percent_subst (DesktopAgnosticFDODesktopEntryGLib* self, const char* code, GSList* documents, gboolean in_single_quotes, gboolean in_double_quotes) {
	char* result = NULL;
	const char* _tmp7_;
	GQuark _tmp8_;
	static GQuark _tmp8__label0 = 0;
	static GQuark _tmp8__label1 = 0;
	static GQuark _tmp8__label2 = 0;
	static GQuark _tmp8__label3 = 0;
	static GQuark _tmp8__label4 = 0;
	static GQuark _tmp8__label5 = 0;
	static GQuark _tmp8__label6 = 0;
	static GQuark _tmp8__label7 = 0;
	static GQuark _tmp8__label8 = 0;
	static GQuark _tmp8__label9 = 0;
	static GQuark _tmp8__label10 = 0;
	static GQuark _tmp8__label11 = 0;
	static GQuark _tmp8__label12 = 0;
	static GQuark _tmp8__label13 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	_tmp7_ = code;
	_tmp8_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	if (_tmp8_ == ((0 != _tmp8__label0) ? _tmp8__label0 : (_tmp8__label0 = g_quark_from_static_string ("%"))))
	switch (0) {
		default:
		{
			result = g_strdup ("%");
			return result;
		}
	} else if ((_tmp8_ == ((0 != _tmp8__label1) ? _tmp8__label1 : (_tmp8__label1 = g_quark_from_static_string ("F")))) || (_tmp8_ == ((0 != _tmp8__label2) ? _tmp8__label2 : (_tmp8__label2 = g_quark_from_static_string ("U")))))
	switch (0) {
		default:
		{
			char* _result_;
			_result_ = g_strdup ("");
			{
				GSList* doc_collection;
				GSList* doc_it;
				doc_collection = documents;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					const char* doc;
					doc = (const char*) doc_it->data;
					{
						char* _tmp0_;
						char* _tmp1_;
						char* _tmp2_;
						_result_ = (_tmp2_ = g_strconcat (_result_, _tmp1_ = g_strconcat (" ", _tmp0_ = desktop_agnostic_fdo_desktop_entry_glib_get_quoted_word (self, doc, in_single_quotes, in_double_quotes), NULL), NULL), _g_free0 (_result_), _tmp2_);
						_g_free0 (_tmp1_);
						_g_free0 (_tmp0_);
					}
				}
			}
			result = _result_;
			return result;
		}
	} else if ((_tmp8_ == ((0 != _tmp8__label3) ? _tmp8__label3 : (_tmp8__label3 = g_quark_from_static_string ("f")))) || (_tmp8_ == ((0 != _tmp8__label4) ? _tmp8__label4 : (_tmp8__label4 = g_quark_from_static_string ("u")))))
	switch (0) {
		default:
		{
			if (documents == NULL) {
				result = g_strdup ("");
				return result;
			} else {
				char* _tmp3_;
				char* _tmp4_;
				result = (_tmp4_ = g_strconcat (" ", _tmp3_ = desktop_agnostic_fdo_desktop_entry_glib_get_quoted_word (self, (const char*) documents->data, in_single_quotes, in_double_quotes), NULL), _g_free0 (_tmp3_), _tmp4_);
				return result;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp8__label5) ? _tmp8__label5 : (_tmp8__label5 = g_quark_from_static_string ("i"))))
	switch (0) {
		default:
		{
			char* icon;
			icon = desktop_agnostic_fdo_desktop_entry_get_icon ((DesktopAgnosticFDODesktopEntry*) self);
			if (icon == NULL) {
				result = g_strdup ("");
				_g_free0 (icon);
				return result;
			} else {
				char* _tmp5_;
				char* _tmp6_;
				result = (_tmp6_ = g_strconcat ("--icon ", _tmp5_ = desktop_agnostic_fdo_desktop_entry_glib_get_quoted_word (self, icon, in_single_quotes, in_double_quotes), NULL), _g_free0 (_tmp5_), _tmp6_);
				_g_free0 (icon);
				return result;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp8__label6) ? _tmp8__label6 : (_tmp8__label6 = g_quark_from_static_string ("c"))))
	switch (0) {
		default:
		{
			char* name;
			name = desktop_agnostic_fdo_desktop_entry_get_name ((DesktopAgnosticFDODesktopEntry*) self);
			if (name == NULL) {
				result = g_strdup ("");
				_g_free0 (name);
				return result;
			} else {
				result = desktop_agnostic_fdo_desktop_entry_glib_get_quoted_word (self, name, in_single_quotes, in_double_quotes);
				_g_free0 (name);
				return result;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp8__label7) ? _tmp8__label7 : (_tmp8__label7 = g_quark_from_static_string ("k"))))
	switch (0) {
		default:
		{
			if (self->priv->_file == NULL) {
				result = g_strdup ("");
				return result;
			} else {
				result = desktop_agnostic_vfs_file_get_uri (self->priv->_file);
				return result;
			}
		}
	} else if ((((((_tmp8_ == ((0 != _tmp8__label8) ? _tmp8__label8 : (_tmp8__label8 = g_quark_from_static_string ("D")))) || (_tmp8_ == ((0 != _tmp8__label9) ? _tmp8__label9 : (_tmp8__label9 = g_quark_from_static_string ("N"))))) || (_tmp8_ == ((0 != _tmp8__label10) ? _tmp8__label10 : (_tmp8__label10 = g_quark_from_static_string ("d"))))) || (_tmp8_ == ((0 != _tmp8__label11) ? _tmp8__label11 : (_tmp8__label11 = g_quark_from_static_string ("n"))))) || (_tmp8_ == ((0 != _tmp8__label12) ? _tmp8__label12 : (_tmp8__label12 = g_quark_from_static_string ("v"))))) || (_tmp8_ == ((0 != _tmp8__label13) ? _tmp8__label13 : (_tmp8__label13 = g_quark_from_static_string ("m")))))
	switch (0) {
		default:
		{
			result = g_strdup ("");
			return result;
		}
	} else
	switch (0) {
		default:
		{
			g_warning ("desktop-entry-impl-glib.vala:436: Unrecognized %%-code '%%%s' in Exec.", code);
			result = g_strdup ("");
			return result;
		}
	}
}


/**
     * Ported from EggDesktopFile.
     */
static char* desktop_agnostic_fdo_desktop_entry_glib_parse_exec (DesktopAgnosticFDODesktopEntryGLib* self, GSList* documents) {
	char* result = NULL;
	char* exec;
	char* command;
	gboolean escape = FALSE;
	gboolean single_quot = FALSE;
	gboolean double_quot = FALSE;
	gboolean _tmp0_;
	char* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	exec = NULL;
	command = g_strdup ("");
	_tmp0_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "Exec", &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		_g_free0 (exec);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		_g_free0 (command);
		_g_free0 (exec);
		return result;
	}
	exec = (_tmp1_ = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Exec"), _g_free0 (exec), _tmp1_);
	escape = single_quot = double_quot = FALSE;
	{
		char* s;
		s = g_strdup (exec);
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				char* chr;
				if (!_tmp2_) {
					char* _tmp3_;
					s = (_tmp3_ = g_strdup (g_utf8_next_char (s)), _g_free0 (s), _tmp3_);
				}
				_tmp2_ = FALSE;
				if (s != NULL) {
					_tmp4_ = g_utf8_strlen (s, -1) > 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				chr = string_substring (s, (glong) 0, (glong) 1);
				if (escape) {
					char* _tmp5_;
					escape = FALSE;
					command = (_tmp5_ = g_strconcat (command, chr, NULL), _g_free0 (command), _tmp5_);
				} else {
					if (_vala_strcmp0 (chr, "\\") == 0) {
						char* _tmp6_;
						if (!single_quot) {
							escape = TRUE;
						}
						command = (_tmp6_ = g_strconcat (command, chr, NULL), _g_free0 (command), _tmp6_);
					} else {
						if (_vala_strcmp0 (chr, "'") == 0) {
							char* _tmp7_;
							gboolean _tmp8_ = FALSE;
							command = (_tmp7_ = g_strconcat (command, chr, NULL), _g_free0 (command), _tmp7_);
							if (!single_quot) {
								_tmp8_ = !double_quot;
							} else {
								_tmp8_ = FALSE;
							}
							if (_tmp8_) {
								single_quot = TRUE;
							} else {
								if (single_quot) {
									single_quot = FALSE;
								}
							}
						} else {
							if (_vala_strcmp0 (chr, "\"") == 0) {
								char* _tmp9_;
								gboolean _tmp10_ = FALSE;
								command = (_tmp9_ = g_strconcat (command, chr, NULL), _g_free0 (command), _tmp9_);
								if (!single_quot) {
									_tmp10_ = !double_quot;
								} else {
									_tmp10_ = FALSE;
								}
								if (_tmp10_) {
									double_quot = TRUE;
								} else {
									if (double_quot) {
										double_quot = FALSE;
									}
								}
							} else {
								if (_vala_strcmp0 (chr, "%") == 0) {
									char* pchr;
									pchr = string_substring (s, (glong) 1, (glong) 1);
									if (pchr == NULL) {
										char* _tmp11_;
										command = (_tmp11_ = g_strconcat (command, chr, NULL), _g_free0 (command), _tmp11_);
									} else {
										char* _tmp12_;
										char* _tmp13_;
										char* _tmp14_;
										command = (_tmp13_ = g_strconcat (command, _tmp12_ = desktop_agnostic_fdo_desktop_entry_glib_do_percent_subst (self, pchr, documents, single_quot, double_quot), NULL), _g_free0 (command), _tmp13_);
										_g_free0 (_tmp12_);
										s = (_tmp14_ = g_strdup (g_utf8_next_char (s)), _g_free0 (s), _tmp14_);
									}
									_g_free0 (pchr);
								} else {
									char* _tmp15_;
									command = (_tmp15_ = g_strconcat (command, chr, NULL), _g_free0 (command), _tmp15_);
								}
							}
						}
					}
				}
				_g_free0 (chr);
			}
		}
		_g_free0 (s);
	}
	result = command;
	_g_free0 (exec);
	return result;
}


static GPid desktop_agnostic_fdo_desktop_entry_glib_do_app_launch (DesktopAgnosticFDODesktopEntryGLib* self, const char* working_dir, GSpawnFlags flags, GSList* documents, GError** error) {
	GPid result = 0;
	gint argv_length1;
	gint _argv_size_;
	char** argv;
	GPid pid = 0;
	char* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	argv = (argv_length1 = 0, NULL);
	_tmp2_ = (_tmp1_ = g_shell_parse_argv (_tmp0_ = desktop_agnostic_fdo_desktop_entry_glib_parse_exec (self, documents), &argv_length1, &argv, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return 0;
	}
	if (!_tmp2_) {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_NOT_LAUNCHABLE, "Could not parse Exec key.");
		{
			g_propagate_error (error, _inner_error_);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			return 0;
		}
	}
	_tmp4_ = g_key_file_has_key (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "Terminal", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return 0;
	}
	if (_tmp4_) {
		_tmp3_ = desktop_agnostic_fdo_desktop_entry_get_boolean ((DesktopAgnosticFDODesktopEntry*) self, "Terminal");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint term_argv_length1;
		gint _term_argv_size_;
		char** _tmp5_;
		char** term_argv;
		char* check;
		char* _tmp6_;
		char** _tmp19_;
		char** _tmp20_;
		term_argv = (_tmp5_ = g_new0 (char*, (argv_length1 + 2) + 1), term_argv_length1 = argv_length1 + 2, _term_argv_size_ = term_argv_length1, _tmp5_);
		check = NULL;
		check = (_tmp6_ = g_find_program_in_path ("gnome-terminal"), _g_free0 (check), _tmp6_);
		if (check != NULL) {
			char* _tmp7_;
			char* _tmp8_;
			term_argv[0] = (_tmp7_ = g_strdup (check), _g_free0 (term_argv[0]), _tmp7_);
			term_argv[1] = (_tmp8_ = g_strdup ("-x"), _g_free0 (term_argv[1]), _tmp8_);
		} else {
			char* _tmp15_;
			char* _tmp16_;
			if (check == NULL) {
				char* _tmp9_;
				check = (_tmp9_ = g_find_program_in_path ("nxterm"), _g_free0 (check), _tmp9_);
			}
			if (check == NULL) {
				char* _tmp10_;
				check = (_tmp10_ = g_find_program_in_path ("color-xterm"), _g_free0 (check), _tmp10_);
			}
			if (check == NULL) {
				char* _tmp11_;
				check = (_tmp11_ = g_find_program_in_path ("rxvt"), _g_free0 (check), _tmp11_);
			}
			if (check == NULL) {
				char* _tmp12_;
				check = (_tmp12_ = g_find_program_in_path ("xterm"), _g_free0 (check), _tmp12_);
			}
			if (check == NULL) {
				char* _tmp13_;
				check = (_tmp13_ = g_find_program_in_path ("dtterm"), _g_free0 (check), _tmp13_);
			}
			if (check == NULL) {
				char* _tmp14_;
				check = (_tmp14_ = g_strdup ("xterm"), _g_free0 (check), _tmp14_);
				g_warning ("desktop-entry-impl-glib.vala:572: couldn't find a terminal, falling ba" \
"ck to xterm");
			}
			term_argv[0] = (_tmp15_ = g_strdup (check), _g_free0 (term_argv[0]), _tmp15_);
			term_argv[1] = (_tmp16_ = g_strdup ("-e"), _g_free0 (term_argv[1]), _tmp16_);
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp17_;
				_tmp17_ = TRUE;
				while (TRUE) {
					char* _tmp18_;
					if (!_tmp17_) {
						i++;
					}
					_tmp17_ = FALSE;
					if (!(i < argv_length1)) {
						break;
					}
					term_argv[i + 2] = (_tmp18_ = g_strdup (argv[i]), _g_free0 (term_argv[i + 2]), _tmp18_);
				}
			}
		}
		argv = (_tmp20_ = (_tmp19_ = term_argv, term_argv = NULL, _tmp19_), argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL), argv_length1 = term_argv_length1, _argv_size_ = argv_length1, _tmp20_);
		_g_free0 (check);
		term_argv = (_vala_array_free (term_argv, term_argv_length1, (GDestroyNotify) g_free), NULL);
	}
	g_spawn_async_with_pipes (working_dir, argv, NULL, flags, NULL, NULL, &pid, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return 0;
	}
	result = pid;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
     * Based on EggDesktopFile's egg_desktop_file_launch().
     * @return the PID of the last process launched.
     */
static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


static GPid desktop_agnostic_fdo_desktop_entry_glib_real_launch (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryLaunchFlags flags, GSList* documents, GError** error) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	GPid result = 0;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	switch (desktop_agnostic_fdo_desktop_entry_get_entry_type ((DesktopAgnosticFDODesktopEntry*) self)) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION:
		{
			GSpawnFlags sflags;
			char* working_dir;
			GPid pid = 0;
			gboolean _tmp2_ = FALSE;
			sflags = G_SPAWN_SEARCH_PATH;
			working_dir = NULL;
			if ((flags & DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_LAUNCH_FLAGS_DO_NOT_REAP_CHILD) != 0) {
				sflags = sflags | G_SPAWN_DO_NOT_REAP_CHILD;
			}
			if ((flags & DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_LAUNCH_FLAGS_USE_CWD) != 0) {
				char* _tmp0_;
				working_dir = (_tmp0_ = g_get_current_dir (), _g_free0 (working_dir), _tmp0_);
			} else {
				char* _tmp1_;
				working_dir = (_tmp1_ = g_strdup (g_get_home_dir ()), _g_free0 (working_dir), _tmp1_);
			}
			if ((flags & DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_LAUNCH_FLAGS_ONLY_ONE) == 0) {
				_tmp2_ = documents != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				pid = (GPid) 0;
				{
					GSList* doc_collection;
					GSList* doc_it;
					doc_collection = documents;
					for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
						const char* doc;
						doc = (const char*) doc_it->data;
						{
							GSList* docs;
							GPid _tmp3_;
							docs = NULL;
							docs = g_slist_append (docs, g_strdup (doc));
							_tmp3_ = desktop_agnostic_fdo_desktop_entry_glib_do_app_launch (self, working_dir, sflags, docs, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								__g_slist_free_g_free0 (docs);
								_g_free0 (working_dir);
								return 0;
							}
							pid = _tmp3_;
							__g_slist_free_g_free0 (docs);
						}
					}
				}
			} else {
				GPid _tmp4_;
				_tmp4_ = desktop_agnostic_fdo_desktop_entry_glib_do_app_launch (self, working_dir, sflags, documents, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (working_dir);
					return 0;
				}
				pid = _tmp4_;
			}
			result = pid;
			_g_free0 (working_dir);
			return result;
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK:
		{
			char* uri;
			DesktopAgnosticVFSFile* file;
			if (documents != NULL) {
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_NOT_LAUNCHABLE, "Cannot pass documents to a 'Link' desktop entry.");
				{
					g_propagate_error (error, _inner_error_);
					return 0;
				}
			}
			uri = g_key_file_get_string (self->priv->_keyfile, DESKTOP_AGNOSTIC_FDO_GROUP, "URL", &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return 0;
			}
			file = desktop_agnostic_vfs_file_new_for_uri (uri, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				return 0;
			}
			desktop_agnostic_vfs_file_launch (file, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				_g_free0 (uri);
				return 0;
			}
			result = (GPid) 0;
			_g_object_unref0 (file);
			_g_free0 (uri);
			return result;
		}
		default:
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_NOT_LAUNCHABLE, "The desktop entry is unlaunchable.");
			{
				g_propagate_error (error, _inner_error_);
				return 0;
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_save (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* new_file, GError** error) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	DesktopAgnosticVFSFile* file;
	char* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	file = NULL;
	if (new_file != NULL) {
		DesktopAgnosticVFSFile* _tmp0_;
		file = (_tmp0_ = _g_object_ref0 (new_file), _g_object_unref0 (file), _tmp0_);
	} else {
		if (self->priv->_file != NULL) {
			DesktopAgnosticVFSFile* _tmp1_;
			file = (_tmp1_ = _g_object_ref0 (self->priv->_file), _g_object_unref0 (file), _tmp1_);
		} else {
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_INVALID_FILE, "No filename specified.");
			{
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				return;
			}
		}
	}
	desktop_agnostic_vfs_file_replace_contents (file, _tmp2_ = g_key_file_to_data (self->priv->_keyfile, NULL, NULL), &_inner_error_);
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (file);
}


DesktopAgnosticFDODesktopEntryGLib* desktop_agnostic_fdo_desktop_entry_glib_construct (GType object_type) {
	DesktopAgnosticFDODesktopEntryGLib * self = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticFDODesktopEntryGLib* desktop_agnostic_fdo_desktop_entry_glib_new (void) {
	return desktop_agnostic_fdo_desktop_entry_glib_construct (DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB);
}


static DesktopAgnosticVFSFile* desktop_agnostic_fdo_desktop_entry_glib_real_get_file (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticFDODesktopEntryGLib* self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	result = self->priv->_file;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_file (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* value) {
	DesktopAgnosticFDODesktopEntryGLib* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	if (value != NULL) {
		if (self->priv->loaded) {
			g_warning ("desktop-entry-impl-glib.vala:46: The desktop entry has already been in" \
"itialized.");
		} else {
			if (desktop_agnostic_vfs_file_exists (value)) {
				char* path;
				DesktopAgnosticVFSFile* _tmp0_;
				char* _tmp1_;
				path = NULL;
				self->priv->_file = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_file), _tmp0_);
				path = (_tmp1_ = desktop_agnostic_vfs_file_get_path (value), _g_free0 (path), _tmp1_);
				if (path == NULL) {
					char* data;
					gsize data_len = 0UL;
					char* _tmp2_ = NULL;
					char* _tmp3_;
					data = NULL;
					desktop_agnostic_vfs_file_load_contents (self->priv->_file, &_tmp2_, &data_len, &_inner_error_);
					data = (_tmp3_ = _tmp2_, _g_free0 (data), _tmp3_);
					if (_inner_error_ != NULL) {
						_g_free0 (data);
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					g_key_file_load_from_data (self->priv->_keyfile, data, data_len, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (data);
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (data);
				} else {
					g_key_file_load_from_file (self->priv->_keyfile, path, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->loaded = TRUE;
				_g_free0 (path);
			}
		}
	}
	g_object_notify ((GObject *) self, "file");
}


static GKeyFile* desktop_agnostic_fdo_desktop_entry_glib_real_get_keyfile (DesktopAgnosticFDODesktopEntry* base) {
	GKeyFile* result;
	DesktopAgnosticFDODesktopEntryGLib* self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	result = self->priv->_keyfile;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_keyfile (DesktopAgnosticFDODesktopEntry* base, GKeyFile* value) {
	DesktopAgnosticFDODesktopEntryGLib* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	if (value != NULL) {
		if (self->priv->loaded) {
			g_warning ("desktop-entry-impl-glib.vala:85: The desktop entry has already been in" \
"itialized.");
		} else {
			char* data;
			gsize length = 0UL;
			char* _tmp0_;
			data = NULL;
			data = (_tmp0_ = g_key_file_to_data (value, &length, NULL), _g_free0 (data), _tmp0_);
			g_key_file_load_from_data (self->priv->_keyfile, data, length, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->loaded = TRUE;
			_g_free0 (data);
		}
	}
	g_object_notify ((GObject *) self, "keyfile");
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_data (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGLib* self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	if (value != NULL) {
		_tmp0_ = _vala_strcmp0 (value, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (self->priv->loaded) {
			g_warning ("desktop-entry-impl-glib.vala:109: The desktop entry has already been i" \
"nitialized.");
		} else {
			g_key_file_load_from_data (self->priv->_keyfile, value, strlen (value), G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->loaded = TRUE;
		}
	}
	g_object_notify ((GObject *) self, "data");
}


static DesktopAgnosticFDODesktopEntryType desktop_agnostic_fdo_desktop_entry_glib_real_get_entry_type (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticFDODesktopEntryType result;
	DesktopAgnosticFDODesktopEntryGLib* self;
	char* type;
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	type = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Type");
	_tmp0_ = type;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("Application"))))
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION;
			_g_free0 (type);
			return result;
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("Link"))))
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK;
			_g_free0 (type);
			return result;
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("Directory"))))
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_DIRECTORY;
			_g_free0 (type);
			return result;
		}
	} else
	switch (0) {
		default:
		{
			result = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_UNKNOWN;
			_g_free0 (type);
			return result;
		}
	}
	_g_free0 (type);
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_entry_type (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryType value) {
	DesktopAgnosticFDODesktopEntryGLib* self;
	char* _tmp0_;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	desktop_agnostic_fdo_desktop_entry_set_string ((DesktopAgnosticFDODesktopEntry*) self, "Type", _tmp0_ = desktop_agnostic_fdo_desktop_entry_type_to_string (value));
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "entry-type");
}


static char* desktop_agnostic_fdo_desktop_entry_glib_real_get_name (DesktopAgnosticFDODesktopEntry* base) {
	char* result;
	DesktopAgnosticFDODesktopEntryGLib* self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	result = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Name");
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_name (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGLib* self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	desktop_agnostic_fdo_desktop_entry_set_string ((DesktopAgnosticFDODesktopEntry*) self, "Name", value);
	g_object_notify ((GObject *) self, "name");
}


static char* desktop_agnostic_fdo_desktop_entry_glib_real_get_icon (DesktopAgnosticFDODesktopEntry* base) {
	char* result;
	DesktopAgnosticFDODesktopEntryGLib* self;
	char* icon_name;
	gboolean _tmp0_ = FALSE;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	icon_name = desktop_agnostic_fdo_desktop_entry_get_string ((DesktopAgnosticFDODesktopEntry*) self, "Icon");
	if (icon_name != NULL) {
		char* _tmp1_;
		_tmp0_ = _vala_strcmp0 (_tmp1_ = g_path_get_basename (icon_name), icon_name) == 0;
		_g_free0 (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char** _tmp2_;
		char** _tmp3_;
		gint _tmp3__length1;
		char* _tmp4_;
		char** _tmp5_;
		char** _tmp6_;
		gint _tmp6__length1;
		char* _tmp7_;
		char** _tmp8_;
		char** _tmp9_;
		gint _tmp9__length1;
		char* _tmp10_;
		icon_name = (_tmp4_ = g_strdup ((_tmp3_ = _tmp2_ = g_strsplit (icon_name, ".png", 2), _tmp3__length1 = _vala_array_length (_tmp2_), _tmp3_)[0]), _g_free0 (icon_name), _tmp4_);
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		icon_name = (_tmp7_ = g_strdup ((_tmp6_ = _tmp5_ = g_strsplit (icon_name, ".svg", 2), _tmp6__length1 = _vala_array_length (_tmp5_), _tmp6_)[0]), _g_free0 (icon_name), _tmp7_);
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		icon_name = (_tmp10_ = g_strdup ((_tmp9_ = _tmp8_ = g_strsplit (icon_name, ".xpm", 2), _tmp9__length1 = _vala_array_length (_tmp8_), _tmp9_)[0]), _g_free0 (icon_name), _tmp10_);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	}
	result = icon_name;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_glib_real_set_icon (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGLib* self;
	self = (DesktopAgnosticFDODesktopEntryGLib*) base;
	if (value == NULL) {
		g_warning ("desktop-entry-impl-glib.vala:179: Cannot set a NULL value for 'Icon'.");
	} else {
		desktop_agnostic_fdo_desktop_entry_set_string ((DesktopAgnosticFDODesktopEntry*) self, "Icon", value);
	}
	g_object_notify ((GObject *) self, "icon");
}


static void desktop_agnostic_fdo_desktop_entry_glib_class_init (DesktopAgnosticFDODesktopEntryGLibClass * klass) {
	desktop_agnostic_fdo_desktop_entry_glib_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticFDODesktopEntryGLibPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_fdo_desktop_entry_glib_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_fdo_desktop_entry_glib_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_fdo_desktop_entry_glib_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_FILE, "file");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_KEYFILE, "keyfile");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_DATA, "data");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ENTRY_TYPE, "entry-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ICON, "icon");
}


static void desktop_agnostic_fdo_desktop_entry_glib_desktop_agnostic_fdo_desktop_entry_interface_init (DesktopAgnosticFDODesktopEntryIface * iface) {
	desktop_agnostic_fdo_desktop_entry_glib_desktop_agnostic_fdo_desktop_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->key_exists = desktop_agnostic_fdo_desktop_entry_glib_real_key_exists;
	iface->get_boolean = desktop_agnostic_fdo_desktop_entry_glib_real_get_boolean;
	iface->set_boolean = desktop_agnostic_fdo_desktop_entry_glib_real_set_boolean;
	iface->get_string = desktop_agnostic_fdo_desktop_entry_glib_real_get_string;
	iface->set_string = desktop_agnostic_fdo_desktop_entry_glib_real_set_string;
	iface->get_localestring = desktop_agnostic_fdo_desktop_entry_glib_real_get_localestring;
	iface->set_localestring = desktop_agnostic_fdo_desktop_entry_glib_real_set_localestring;
	iface->get_string_list = desktop_agnostic_fdo_desktop_entry_glib_real_get_string_list;
	iface->set_string_list = desktop_agnostic_fdo_desktop_entry_glib_real_set_string_list;
	iface->exists = desktop_agnostic_fdo_desktop_entry_glib_real_exists;
	iface->launch = desktop_agnostic_fdo_desktop_entry_glib_real_launch;
	iface->save = desktop_agnostic_fdo_desktop_entry_glib_real_save;
	iface->get_file = desktop_agnostic_fdo_desktop_entry_glib_real_get_file;
	iface->set_file = desktop_agnostic_fdo_desktop_entry_glib_real_set_file;
	iface->get_keyfile = desktop_agnostic_fdo_desktop_entry_glib_real_get_keyfile;
	iface->set_keyfile = desktop_agnostic_fdo_desktop_entry_glib_real_set_keyfile;
	iface->set_data = desktop_agnostic_fdo_desktop_entry_glib_real_set_data;
	iface->get_entry_type = desktop_agnostic_fdo_desktop_entry_glib_real_get_entry_type;
	iface->set_entry_type = desktop_agnostic_fdo_desktop_entry_glib_real_set_entry_type;
	iface->get_name = desktop_agnostic_fdo_desktop_entry_glib_real_get_name;
	iface->set_name = desktop_agnostic_fdo_desktop_entry_glib_real_set_name;
	iface->get_icon = desktop_agnostic_fdo_desktop_entry_glib_real_get_icon;
	iface->set_icon = desktop_agnostic_fdo_desktop_entry_glib_real_set_icon;
}


static void desktop_agnostic_fdo_desktop_entry_glib_instance_init (DesktopAgnosticFDODesktopEntryGLib * self) {
	self->priv = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_GET_PRIVATE (self);
	self->priv->_keyfile = g_key_file_new ();
	self->priv->loaded = FALSE;
	self->priv->_file = NULL;
}


static void desktop_agnostic_fdo_desktop_entry_glib_finalize (GObject* obj) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB (obj);
	_g_key_file_free0 (self->priv->_keyfile);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (desktop_agnostic_fdo_desktop_entry_glib_parent_class)->finalize (obj);
}


GType desktop_agnostic_fdo_desktop_entry_glib_get_type (void) {
	static volatile gsize desktop_agnostic_fdo_desktop_entry_glib_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_fdo_desktop_entry_glib_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticFDODesktopEntryGLibClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_fdo_desktop_entry_glib_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticFDODesktopEntryGLib), 0, (GInstanceInitFunc) desktop_agnostic_fdo_desktop_entry_glib_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_fdo_desktop_entry_info = { (GInterfaceInitFunc) desktop_agnostic_fdo_desktop_entry_glib_desktop_agnostic_fdo_desktop_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_fdo_desktop_entry_glib_type_id;
		desktop_agnostic_fdo_desktop_entry_glib_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticFDODesktopEntryGLib", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_fdo_desktop_entry_glib_type_id, DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY, &desktop_agnostic_fdo_desktop_entry_info);
		g_once_init_leave (&desktop_agnostic_fdo_desktop_entry_glib_type_id__volatile, desktop_agnostic_fdo_desktop_entry_glib_type_id);
	}
	return desktop_agnostic_fdo_desktop_entry_glib_type_id__volatile;
}


static void desktop_agnostic_fdo_desktop_entry_glib_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_FILE:
		g_value_set_object (value, desktop_agnostic_fdo_desktop_entry_get_file ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_KEYFILE:
		g_value_set_pointer (value, desktop_agnostic_fdo_desktop_entry_get_keyfile ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ENTRY_TYPE:
		g_value_set_enum (value, desktop_agnostic_fdo_desktop_entry_get_entry_type ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_NAME:
		g_value_take_string (value, desktop_agnostic_fdo_desktop_entry_get_name ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ICON:
		g_value_take_string (value, desktop_agnostic_fdo_desktop_entry_get_icon ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_fdo_desktop_entry_glib_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticFDODesktopEntryGLib * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_FILE:
		desktop_agnostic_fdo_desktop_entry_set_file ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_KEYFILE:
		desktop_agnostic_fdo_desktop_entry_set_keyfile ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_pointer (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_DATA:
		desktop_agnostic_fdo_desktop_entry_set_data ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ENTRY_TYPE:
		desktop_agnostic_fdo_desktop_entry_set_entry_type ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_enum (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_NAME:
		desktop_agnostic_fdo_desktop_entry_set_name ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GLIB_ICON:
		desktop_agnostic_fdo_desktop_entry_set_icon ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_plugin (void) {
	GType result = 0UL;
	result = DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GLIB;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




