/** \file
 * Defines the interface for the Constructor class.
 *
 * \author Martin F. Krafft <krafft@ailab.ch>
 * \date $Date: 2004/06/01 13:02:02 $
 * \version $Revision: 1.14 $
 */

#ifndef __INCLUDE_FACTORY_CONSTRUCTOR_H__
#define __INCLUDE_FACTORY_CONSTRUCTOR_H__

namespace Factory
{
  /**
     Constructors are functors that construct objects in pre-allocated space.


     More to say here...
  */
  template <typename _Type>
    class Constructor
    {
    public:
      inline Constructor() {}
      template <typename _SubType>
        Constructor(Constructor<_SubType>)
          { _SubType* __s; _Type* __t = __s; }
      
      /**
       */
      virtual inline _Type*
      operator()(_Type* __p)
      {
        return this->call_constructor(__p);
      }

      /**
       */
      virtual inline _Type*
      operator()(_Type* __p) const
      {
        return this->call_constructor(__p);
      }

      /**
       */
      virtual inline _Type*
      operator()(_Type* __p, _Type const& __THAT)
      {
        return this->call_copy_constructor(__p, __THAT);
      }

      /**
       */
      virtual inline _Type*
      operator()(_Type* __p, _Type const& __THAT) const
      {
        return this->call_copy_constructor(__p, __THAT);
      }

    protected:

      /**
       */
      inline _Type* call_constructor(_Type* __p) const
      {
        return new (static_cast<void*>(__p)) _Type();
      }

      /**
       */
      inline _Type* call_copy_constructor(_Type* __p, _Type const& __THAT) const
      {
        return new (static_cast<void*>(__p)) _Type(__THAT);
      }

    };
}; // namespace Factory

#endif // include guard

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
