/** \file
 * Defines the interface for the ConstructionRequest class.
 *
 * \author Martin F. Krafft <krafft@ailab.ch>
 * \date $Date: 2004/05/16 15:57:33 $
 * \version $Revision: 1.1 $
 */

#ifndef __INCLUDE_FACTORY_CONSTRUCTIONREQUEST_H__
#define __INCLUDE_FACTORY_CONSTRUCTIONREQUEST_H__

#include <factory++/constructor.hpp>
#include <factory++/destructor.hpp>

namespace Factory
{
  template <typename _Key>
    class _XstructionRequest_base
    {
    public:

      inline _Key
      const& key() const
      {
        return _M_key;
      }

    protected:
      inline
      _XstructionRequest_base(_Key const& __KEY)
        : _M_key(__KEY) {}

    private:
      _Key const _M_key;
    };

  template <typename _Key, typename _Xstructor>
    class _XstructionRequest : public _XstructionRequest_base<_Key>
    {
    protected:
      typedef _XstructionRequest_base<_Key> _XstructionRequest_base;
      
      inline
      _XstructionRequest(_Key const& __KEY)
        : _XstructionRequest_base(__KEY), _M_xstructor(NULL) {}
      inline
      _XstructionRequest(_Key const& __KEY, _Xstructor& __xstructor)
        : _XstructionRequest_base(__KEY), _M_xstructor(&__xstructor) {}

      inline _Xstructor&
      _M_get_xstructor() const
      {
        // TODO: null pointer exception
        return *_M_xstructor;
      }

      inline bool
      _M_has_xstructor() const
      {
        return _M_xstructor != NULL;
      }

    private:
      _Key const _M_key;
      _Xstructor* const _M_xstructor;
    };

  template <typename _Key, typename _Constructor>
    class ConstructionRequest
    : public _XstructionRequest<_Key, _Constructor>
    {
    public:
      typedef _XstructionRequest<_Key, _Constructor> _XstructionRequest;
      
      ConstructionRequest(_Key const& __KEY)
        : _XstructionRequest(__KEY) {}
      ConstructionRequest(_Key const& __KEY,
                          _Constructor& __constructor)
        : _XstructionRequest(__KEY, __constructor) {}

      inline _Constructor&
      constructor() const
      {
        // TODO: null pointer exception
        return _M_get_xstructor();
      }

      inline bool
      has_constructor() const
      {
        return _M_has_xstructor();
      }
    };

  template <typename _Key, typename _Destructor>
    class DestructionRequest
    : public _XstructionRequest<_Key, _Destructor>
    {
    public:
      typedef _XstructionRequest<_Key, _Destructor> _XstructionRequest;
      
      DestructionRequest(_Key const& __KEY)
        : _XstructionRequest(__KEY) {}
      DestructionRequest(_Key const& __KEY,
                         _Destructor& __destructor)
        : _XstructionRequest(__KEY, __destructor) {}

      inline _Destructor const&
      destructor() const
      {
        // TODO: null pointer exception
        return _M_get_xstructor();
      }

      inline bool
      has_destructor() const
      {
        return _M_has_xstructor();
      }
    };

}; // namespace Factory

#endif // include guard

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
