/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * FormulaParseException.java
 * ------------
 */

package org.pentaho.reporting.libraries.formula.parser;

import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;

/**
 * Todo: Document me!
 *
 * @author : Thomas Morgner
 */
public class FormulaParseException extends ParseException
{
  private ParsePosition parsePosition;
  private TokenMgrError error;
  private Token currentTokenVal;
  private Throwable parent;

  public FormulaParseException(final String message)
  {
    super(message);
  }

  public FormulaParseException(final ParseException pe)
  {
    this(pe.currentToken, pe.expectedTokenSequences, pe.tokenImage);
    this.parent = pe;
  }

  public FormulaParseException(final Token currentTokenVal,
                               final int[][] expectedTokenSequencesVal,
                               final String[] tokenImageVal)
  {
    super(currentTokenVal, expectedTokenSequencesVal, tokenImageVal);
    this.currentTokenVal = currentTokenVal;
    parsePosition = new ParsePosition
       (currentTokenVal.beginLine, currentTokenVal.beginColumn,
           currentTokenVal.endLine, currentTokenVal.endColumn);
  }

  public Token getCurrentTokenVal()
  {
    return currentTokenVal;
  }

  public Throwable getParent()
  {
    return parent;
  }

  public FormulaParseException(final TokenMgrError error)
  {
    super(error.getMessage());
    this.error = error;
    this.parent = error;
    this.parsePosition = new ParsePosition
        (error.getErrorLine(), error.getErrorColumn(), error.getErrorLine(), error.getErrorColumn());
  }

  public TokenMgrError getError()
  {
    return error;
  }

  public ParsePosition getParsePosition()
  {
    return parsePosition;
  }
}
