/**
 * @file libgalago-gtk/galago-gtk-presence-label.h Presence label widget
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_PRESENCE_LABEL_H_
#define _GALAGO_GTK_PRESENCE_LABEL_H_

typedef struct _GalagoGtkPresenceLabel      GalagoGtkPresenceLabel;
typedef struct _GalagoGtkPresenceLabelClass GalagoGtkPresenceLabelClass;
typedef struct _GalagoGtkPresenceLabelPriv  GalagoGtkPresenceLabelPriv;

#include <libgalago/galago.h>
#include <gtk/gtklabel.h>

#define GALAGO_GTK_TYPE_PRESENCE_LABEL (galago_gtk_presence_label_get_type())
#define GALAGO_GTK_PRESENCE_LABEL(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_PRESENCE_LABEL, GalagoGtkPresenceLabel))
#define GALAGO_GTK_PRESENCE_LABEL_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_PRESENCE_LABEL, GalagoGtkPresenceLabelClass))
#define GALAGO_GTK_IS_PRESENCE_LABEL(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_PRESENCE_LABEL))
#define GALAGO_GTK_IS_PRESENCE_LABEL_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_PRESENCE_LABEL))
#define GALAGO_GTK_PRESENCE_LABEL_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_PRESENCE_LABEL, GalagoGtkPresenceLabelClass))

struct _GalagoGtkPresenceLabel
{
	GtkLabel parent_object;

	GalagoGtkPresenceLabelPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkPresenceLabelClass
{
	GtkLabelClass parent_class;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_presence_label_get_type(void);

GtkWidget *galago_gtk_presence_label_new(void);

void galago_gtk_presence_label_set_account(GalagoGtkPresenceLabel *label,
										  GalagoAccount *account);
void galago_gtk_presence_label_set_person(GalagoGtkPresenceLabel *label,
										 GalagoPerson *person);
void galago_gtk_presence_label_set_dim_idle(GalagoGtkPresenceLabel *label,
											gboolean dim_idle);
void galago_gtk_presence_label_set_show_idle_times(GalagoGtkPresenceLabel *label,
												   gboolean show_idle_times);

void galago_gtk_presence_label_update(GalagoGtkPresenceLabel *label);

GalagoAccount *galago_gtk_presence_label_get_account(const GalagoGtkPresenceLabel *label);
GalagoPerson *galago_gtk_presence_label_get_person(const GalagoGtkPresenceLabel *label);
gboolean galago_gtk_presence_label_get_dim_idle(const GalagoGtkPresenceLabel *label);
gboolean galago_gtk_presence_label_get_show_idle_times(const GalagoGtkPresenceLabel *label);

G_END_DECLS

#endif /* _GALAGO_GTK_PRESENCE_LABEL_H_ */
