/**
 * @file list-my-accounts.c Displays a list of all accounts
 *                          from the "Me" user.
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int
main(int argc, char **argv)
{
	GList *l;
	GalagoPerson *me;

	if (!galago_init("list-accounts-test", GALAGO_INIT_CLIENT) ||
		!galago_is_connected())
	{
		fprintf(stderr, "Unable to connect to the Galago service.\n");
		exit(1);
	}

	me = galago_get_me(GALAGO_REMOTE, TRUE);

	for (l = galago_person_get_accounts(me, TRUE); l != NULL; l = l->next)
	{
		GalagoAccount *account = (GalagoAccount *)l->data;

		printf("%s (%s)\n",
			   galago_account_get_username(account),
			   galago_service_get_name(galago_account_get_service(account)));
	}

	return 0;
}
