/*
 * Main Galago include file.
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_H_
#define _GALAGO_H_

/**
 * @mainpage libgalago
 * @section intro_sec Introduction
 *
 * Galago is a desktop presence framework, designed to transmit presence
 * information between programs. To put it in simpler terms, it takes
 * information about who is online and their away/idle states from an instant
 * messenger (such as gaim) or other similar programs and allows other
 * programs (such as Novell Evolution) to make use of it.
 *
 * The project home page is at http://www.galago-project.org/.
 *
 * @defgroup Presence Presence functions
 * @defgroup Utility Utility functions
 */

#include <libgalago/galago-account.h>
#include <libgalago/galago-assert.h>
#include <libgalago/galago-core.h>
#include <libgalago/galago-context.h>
#include <libgalago/galago-dbus.h>
#include <libgalago/galago-enum-types.h>
#include <libgalago/galago-key-value.h>
#include <libgalago/galago-object.h>
#include <libgalago/galago-person.h>
#include <libgalago/galago-presence.h>
#include <libgalago/galago-service.h>
#include <libgalago/galago-status.h>

#endif /* _GALAGO_H_ */
