#include "cxml.h"

void DisplayXMLNode (CXMLElementNode *xmlNode, int n=0)
{
	for (size_t i=0; i<n; i++) ::fprintf (stdout, " ");
	::fprintf (stdout, "<%s", ::xml_node_get_name(xmlNode).Get());

	for (size_t i=0; i<xml_node_get_attributes_number(xmlNode); i++)
	{
		::fprintf (stdout, " %s=\"%s\"", ::xml_node_get_attribute(xmlNode,i).GetName().Get(), 
			   ::xml_node_get_attribute(xmlNode,i).GetValue().Get());
	}

	CString inValue (::xml_node_get_value(xmlNode)-'\n'-' ');
	if (inValue.GetLength() > 0) ::fprintf (stdout, ">%s", (::xml_node_get_value(xmlNode)-'\n').Get()); 
	else if (xml_node_get_children_number(xmlNode) == 0) ::fprintf (stdout, ">");
	else ::fprintf (stdout, ">\n");
	
	for (size_t i=0; i<xml_node_get_children_number(xmlNode); i++)
		::DisplayXMLNode (::xml_node_get_child(xmlNode,i), n+1);

	if (xml_node_get_children_number(xmlNode) > 0 && inValue.GetLength() == 0) for (size_t i=0; i<n; i++) ::fprintf (stdout, " ");
	::fprintf (stdout, "</%s>\n", ::xml_node_get_name(xmlNode).Get());
}

int main (int argc, char **argv)
{
	if (argc != 2) 
	{
		fprintf (stdout, "%s file.xml\n", argv[0]);
		return 1;
	}

	try
	{
		CXMLDocument inXMLDoc (CString(argv[1]), XML_READ);
		CXMLElementNode *xmlRoot = inXMLDoc.GetRootElement ();

		::fprintf (stdout, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");

		::DisplayXMLNode (xmlRoot);

		delete xmlRoot;
	}
	catch (CException *e)
	{
		fprintf (stderr, "%s\n", e->GetMessage().Get());
		return -1;
	}
 
	return 0;
}
