/*
******************************************************************************

   Generic default library defines

   Copyright (C) 2000 Christoph Eggerg	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _LIBGCP_DEFAULT_COLOR_H
#define _LIBGCP_DEFAULT_COLOR_H

#include <ggi/internal/gcp.h>
#include <ggi/internal/gcp_debug.h>
#include <ggi/internal/color.h>


/* Color palette manipulation
 */

/* RGBA */
gcpfunc_MapRGBAColor		GGI_color_MapRGBAColor;
gcpfunc_UnmapRGBAPixel		GGI_color_UnmapRGBAPixel;

gcpfunc_PackRGBAColors		GGI_color_PackRGBAColors;
gcpfunc_UnpackRGBAPixels	GGI_color_UnpackRGBAPixels;
gcpfunc_GetRGBAPalette		GGI_color_GetRGBAPalette;
gcpfunc_SetRGBAPalette		GGI_color_SetRGBAPalette;


/* YUV */
gcpfunc_MapYUVColor		GGI_color_MapYUVColor;
gcpfunc_UnmapYUVPixel		GGI_color_UnmapYUVPixel;

gcpfunc_PackYUVColors		GGI_color_PackYUVColors;
gcpfunc_UnpackYUVPixels		GGI_color_UnpackYUVPixels;

gcpfunc_GetYUVPalette		GGI_color_GetYUVPalette;
gcpfunc_SetYUVPalette		GGI_color_SetYUVPalette;


/* CMYK */
gcpfunc_MapCMYKColor		GGI_color_MapCMYKColor;
gcpfunc_UnmapCMYKPixel		GGI_color_UnmapCMYKPixel;

gcpfunc_PackCMYKColors		GGI_color_PackCMYKColors;
gcpfunc_UnpackCMYKPixels	GGI_color_UnpackCMYKPixels;

gcpfunc_GetCMYKPalette		GGI_color_GetCMYKPalette;
gcpfunc_SetCMYKPalette		GGI_color_SetCMYKPalette;


/* HSV */
gcpfunc_MapHSVColor		GGI_color_MapHSVColor;
gcpfunc_UnmapHSVPixel		GGI_color_UnmapHSVPixel;

gcpfunc_PackHSVColors		GGI_color_PackHSVColors;
gcpfunc_UnpackHSVPixels		GGI_color_UnpackHSVPixels;

gcpfunc_GetHSVPalette		GGI_color_GetHSVPalette;
gcpfunc_SetHSVPalette		GGI_color_SetHSVPalette;


/* Kodak PhotoCD */
gcpfunc_MapYCCColor		GGI_color_MapYCCColor;
gcpfunc_UnmapYCCPixel		GGI_color_UnmapYCCPixel;

gcpfunc_PackYCCColors		GGI_color_PackYCCColors;
gcpfunc_UnpackYCCPixels		GGI_color_UnpackYCCPixels;

gcpfunc_GetYCCPalette		GGI_color_GetYCCPalette;
gcpfunc_SetYCCPalette		GGI_color_SetYCCPalette;




/* Gamma map manipulation
 */

/* RGBA */
gcpfunc_GetRGBAGamma		GGI_color_GetRGBAGamma;
gcpfunc_SetRGBAGamma		GGI_color_SetRGBAGamma;

gcpfunc_GetRGBAGammaMap		GGI_color_GetRGBAGammaMap;
gcpfunc_SetRGBAGammaMap		GGI_color_SetRGBAGammaMap;


/* YUV */
gcpfunc_GetYUVGamma		GGI_color_GetYUVGamma;
gcpfunc_SetYUVGamma		GGI_color_SetYUVGamma;

gcpfunc_GetYUVGammaMap		GGI_color_GetYUVGammaMap;
gcpfunc_SetYUVGammaMap		GGI_color_SetYUVGammaMap;


/* CMYK */
gcpfunc_GetCMYKGamma		GGI_color_GetCMYKGamma;
gcpfunc_SetCMYKGamma		GGI_color_SetCMYKGamma;

gcpfunc_GetCMYKGammaMap		GGI_color_GetCMYKGammaMap;
gcpfunc_SetCMYKGammaMap		GGI_color_SetCMYKGammaMap;


/* HSV */
gcpfunc_GetHSVGamma		GGI_color_GetHSVGamma;
gcpfunc_SetHSVGamma		GGI_color_SetHSVGamma;

gcpfunc_GetHSVGammaMap		GGI_color_GetHSVGammaMap;
gcpfunc_SetHSVGammaMap		GGI_color_SetHSVGammaMap;


/* Kodak PhotoCD */
gcpfunc_GetYCCGamma		GGI_color_GetYCCGamma;
gcpfunc_SetYCCGamma		GGI_color_SetYCCGamma;

gcpfunc_GetYCCGammaMap		GGI_color_GetYCCGammaMap;
gcpfunc_SetYCCGammaMap		GGI_color_SetYCCGammaMap;




/* Blending manipulation
 */

/* Color blending */
gcpfunc_BlendColor		GGI_color_BlendColor;


/* Luminance manipulation
 */

gcpfunc_GetLuminance		GGI_color_GetLuminance;


/* Lightness manipulation
 */

gcpfunc_SetIntensity		GGI_color_SetIntensity;
gcpfunc_GetIntensity		GGI_color_GetIntensity;






#endif /* _LIBGCP_DEFAULT_COLOR_H */
