/**
 * @file namespace.c Namespace functions
 *
 * $Id: namespace.c,v 1.2 2001/07/28 08:39:50 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <gnurdf.h>
#include <libgnurdf/internal.h>

RdfNamespace *
rdfNewNamespace(RdfSchema *schema, const char *uri, const char *prefix)
{
	xmlNs *ns;

	if (schema == NULL || uri == NULL || prefix == NULL)
		return NULL;

	ns = xmlNewNs(schema->xmlRootNode, (xmlChar *)uri, (xmlChar *)prefix);

	return (RdfNamespace *)ns;
}

RdfNamespace *
rdfGetNamespace(RdfSchema *schema, const char *uri)
{
	if (schema == NULL || uri == NULL)
		return NULL;
	
	return (RdfNamespace *)xmlSearchNsByHref(schema, schema->xmlRootNode,
											 (xmlChar *)uri);
}

RdfNamespace *
rdfGetRdfNamespace(RdfSchema *schema)
{
	RdfNamespace *ns;

	if (schema == NULL)
		return NULL;
	
	/* Check for the latest RDF namespace. */
	ns = rdfGetNamespace(schema,
						 "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
	
	if (ns != NULL)
		return (RdfNamespace *)ns;
	
	/* None found. Return a new one. */
	return rdfNewNamespace(schema,
						   "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
	                       "RDF");
}

const char *
rdfGetNamespaceURI(RdfNamespace *ns)
{
	if (ns == NULL)
		return NULL;

	return ns->href;
}

const char *
rdfGetNamespacePrefix(RdfNamespace *ns)
{
	if (ns == NULL)
		return NULL;

	return ns->prefix;
}

