/*******************************************************************************************************************************************
 cmessagedialog.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CForm
		         |--CDialog
			    |--CMessageDialog

 CMessageDialog implements GtkMessageDialog and displays a dialog with an image representing the type of message (error, question, etc...)
 alongside some message text. It's simply a convenience widget; you could construct the equivalent of CMessageDialog/GtkMessageDialog from
 CDialog/GtkDialog without too much effort, but this definition saves typing.
*******************************************************************************************************************************************/

#ifndef __CMESSAGEDIALOG_H__
#define __CMESSAGEDIALOG_H__

#include "cdialog.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// message dialog type
//-----------------------------------------------------------------------------------------------------------------------------------------
typedef enum
{
	MESSAGEDIALOG_INFORMATION=0,
	MESSAGEDIALOG_WARNING,
	MESSAGEDIALOG_QUESTION,
	MESSAGEDIALOG_ERROR
} TMessageDialog;

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cmessagedialog type="information|warning|question|error">
//   <message>string</message>
//    ...
// </cmessagedialog>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_MESSAGEDIALOG_ELEMENT	 ("cmessagedialog");
static CString XML_MESSAGEDIALOG_ATTR_TYPE	 ("type");
static CString XML_MESSAGEDIALOG_MESSAGE_ELEMENT ("message");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CMessageDialog class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMessageDialog : public CDialog
{
	// instanciation section
	public :

		CMessageDialog			(CForm *inOwner=NULL, const CString &inCaption=CString(), const CString &inLabel=CString(),
						 const int inButtons=_DBNone_, const TMessageDialog inDialog=MESSAGEDIALOG_INFORMATION,
						 const bool inModal=false, const CDialogListener *inListener=NULL);
		virtual ~CMessageDialog		();

	// protected gtk widget handling
	protected :

		// perform the widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CSerialized redefinition
	public :

		// message dialog xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

	// protected attributes
	protected :
		
		// dialog message, message dialog type
		CString				m_Message;
		TMessageDialog			m_MessageDialog;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('mdlg', CMessageDialog, CDialog);

#endif
