#include "cmessagedialog.h"

//----------------------------------------------------------------------------------------------------------------------------------------
// CMainFormListener
//----------------------------------------------------------------------------------------------------------------------------------------
class CMainFormListener : public CFormListener
{
        virtual void OnQueryClose (CObject *inSender, Bool &ioDoClose)
        {
                switch (CMessageDialog (static_cast <CForm *> (inSender), CString("Confirmation"),
                        CString("You are about to close this xml dump sample, you can now play with the \"./gtkol-dump.xml\" file before")
                        + " launching again.\n\nAre you sure you want to quit ?", _DBYesNo_,
                        MESSAGEDIALOG_QUESTION, true).Run ())
                {
                        case DIALOG_YES : ioDoClose = true;  break;
                        default         : ioDoClose = false; break;
                }
        }

        virtual void OnClose (CObject *)
        {
                CXMLDocument XMLDoc (CString("./gtkol-dump.xml"), XML_WRITE, CString("gtkol"));
                XMLDoc << CComponent::GetComponent (1L);
        }

        SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('_mfm', CMainFormListener, CFormListener);
RESOLVE_DYNAMIC_METACLASS (CMainFormListener);

DECLARE_METAMODULE_EXPORT (CMainFormListener);
