MODULE VO:Dlg:File;

IMPORT D   := VO:Base:Display,
       O   := VO:Base:Object,
       U   := VO:Base:Util,
       Z   := VO:Base:Size,

       MF  := VO:Model:DirTable,
       MT  := VO:Model:Table,
       MV  := VO:Model:Value,

       B   := VO:Button,
       BR  := VO:ButtonRow,
       G   := VO:Object,
       P   := VO:Panel,
       S   := VO:Space,
       ST  := VO:String,
       TB  := VO:Table,
       TV  := VO:TableView,
       W   := VO:Window,
       WG  := VO:WindowGroup,

       str := Strings,

       Dir := Directory;

TYPE
  FileDlg     * = POINTER TO FileDlgDesc;
  FileDlgDesc * = RECORD (W.WindowDesc)
                    full-   : MV.StringModel;
                    path-   : MV.StringModel;
                    file-   : MV.StringModel;
                    model   : MF.DirModel;
                    result- : BOOLEAN;
                  END;

  PROCEDURE ReadDir(name : ARRAY OF CHAR):MF.DirList;

  VAR
    list,
    help    : MF.DirList;
    current : MF.DirEntry;
    pos,x   : LONGINT;
    d       : Dir.Handle;
    full    : ARRAY 1024 OF CHAR;

  BEGIN
    d:=Dir.OpenDir(name);
    IF d#0 THEN
      list:=NIL;

      pos:=0;
      WHILE Dir.GetDirEntry(d,full) DO
        IF (list=NIL) OR (pos>=LEN(list^)) THEN
           NEW(help,pos+1000 );
          IF list#NIL THEN
             FOR x:=0 TO LEN(list^)-1 DO
                help[ x]:=list[x];
             END;
           END;
           list:=help;
        END;

        NEW(current);
        NEW(current. fileName,str.Length(full)+1);
        COPY(full,current.fileName^);
        COPY(name,full);
        IF Dir.Append(full ,current.fileName^) THEN END;
        Dir.GetDetails({Dir. type,Dir.size},full,current) ;
        list[pos ]:=current;
        INC(pos);
      END;

      IF pos<LEN(list^) THEN
        list[pos]:=NIL;
      END;

      Dir.CloseDir(d);

      RETURN list;
    ELSE
      RETURN NIL;
    END;
  END ReadDir;

  PROCEDURE (d : FileDlg) Init*;

  VAR
    buffer : ARRAY 1024 OF CHAR;

  BEGIN
    d.Init^;

    Dir.GetCurrentDirectory(buffer);

    NEW(d.full);
    d.full.Init;
    d.full.SetString(buffer);

    NEW(d.path);
    d.path.Init;
    d.path.SetString(buffer);

    NEW(d.file);
    d.file.Init;
    d.file.SetString("");
  END Init;

  PROCEDURE (d : FileDlg) PreInit*;

  VAR
    vPanel  : P.Panel;
    button  : B.Button;
    row     : BR.ButtonRow;
    space   : S.Space;
    string  : ST.String;
    wGroup  : WG.WindowGroup;
    table   : TB.Table;
    res     : MF.DirList;
    path    : U.Text;
    parent  : D.Window;

  BEGIN
    vPanel:=P.CreateVPanel();
    vPanel.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(d.model);
      d.model.Init;
      path:=d.path.GetText();
      res:=ReadDir(path^);
      d.model.SetDir(res);
      d.model.SetSelectionType(MT.singleLineSelect);
      d.model.Forward(MT.selectionMsg,d);

      table:=TB.CreateTable();
      table.SetFlags({G.horizontalFlex,G.verticalFlex});
      table.SetWidth(Z.screenHRel,30);
      table.SetHeight(Z.screenVRel,30);
      table.SetShowHeader(TRUE);
      table.SetModel(d.model);
      table.table.Forward(TV.mouseSelectionMsg,d);
      table.table.Forward(TV.doubleClickMsg,d);
      d.AddFocusObject(table.table);
    vPanel.Add(table);


      space:=S.CreateVSpace();
    vPanel.Add(space);

      string:=ST.CreateString();
      string.SetFlags({G.horizontalFlex});
      string.SetReadOnly(TRUE);
      string.SetModel(d.full);
    vPanel.Add(string);

      space:=S.CreateVSpace();
    vPanel.Add(space);

      row:=BR.CreateButtonRow();
      row.SetFlags({G.horizontalFlex});

        button:=B.CreateButton();
        button.SetFlags({G.horizontalFlex,G.verticalFlex});
        button.SetLabelText("OK*");
        button.SetId(0);
        button.Forward(B.pressedMsg,d);
        d.AddFocusObject(button);
      row.Add(button);

        button:=B.CreateButton();
        button.SetFlags({G.horizontalFlex,G.verticalFlex});
        button.SetLabelText("Cancel^");
        button.SetId(1);
        button.Forward(B.pressedMsg,d);
        d.AddFocusObject(button);
      row.Add(button);
    vPanel.Add(row);

    wGroup:=WG.CreateWindowGroup();
    parent:=d.GetParent();
    IF parent#NIL THEN
      wGroup.SetWidth(Z.pixel,(80*parent.width) DIV 100);
      wGroup.SetHeight(Z.pixel,(80*parent.height) DIV 100);
    END;
    wGroup.Set(NIL,vPanel,TRUE);

    d.SetTop(wGroup);

    d.Forward(W.closeMsg,d);

    d.result:=FALSE;

    d.PreInit^;
  END PreInit;

  PROCEDURE (d : FileDlg) OnMouseSelection;

  VAR
    entry : MF.DirEntry;
    res   : MF.DirList;
    oPath : ARRAY 1024 OF CHAR;

  BEGIN
    d.path.GetString(oPath);
    entry:=d.model.GetSelection();
    IF (entry#NIL) & (entry.fileName#NIL) & (entry.fileName^#".") THEN
      IF entry.fileName^=".." THEN
        IF Dir.Up(oPath) THEN
          res:=ReadDir(oPath);
          IF res#NIL THEN
            d.path.SetString(oPath);
            d.full.SetString(oPath);
            d.model.SetDir(res);
          END;
        END;
      ELSE
        IF Dir.Append(oPath,entry.fileName^) THEN
          res:=ReadDir(oPath);
          IF res#NIL THEN
            d.path.SetString(oPath);
            d.full.SetString(oPath);
            d.model.SetDir(res);
          END;
        END;
      END;
    END;
  END OnMouseSelection;

  PROCEDURE (d : FileDlg) OnSelectionChange;

  VAR
    oFull : ARRAY 1024 OF CHAR;
    entry : MF.DirEntry;

  BEGIN
    d.path.GetString(oFull);
    entry:=d.model.GetSelection();
    IF (entry#NIL) & (entry.fileName#NIL) & (entry.fileName^#".") & (entry.fileName^#"..") THEN
      IF Dir.Append(oFull,entry.fileName^) THEN
        d.file.SetString(entry.fileName^);
        d.full.SetString(oFull);
      END;
    END;
  END OnSelectionChange;

  PROCEDURE (d : FileDlg) OnDoubleClick;

  VAR
    entry : MF.DirEntry;

  BEGIN
    entry:=d.model.GetSelection();
    IF (entry#NIL) & (entry.fileName#NIL) & (entry.fileName^#".") & (entry.fileName^#"..") THEN
      IF entry.type#Dir.directory THEN
        d.result:=TRUE;
        d.Exit;
      END;
    END;
  END OnDoubleClick;

  PROCEDURE (d : FileDlg) Receive*(message : O.Message);

  BEGIN
    WITH
      message : B.PressedMsg DO
        d.result:=message.source.id=0;
        d.Exit;
    | message : W.CloseMsg DO
        d.result:=FALSE;
        d.Exit;
    | message : TV.MouseSelectionMsg DO
        d.OnMouseSelection;
    | message : TV.DoubleClickMsg DO
        d.OnDoubleClick;
    | message : MT.SelectionMsg DO
        d.OnSelectionChange;
    ELSE
      d.Receive^(message);
    END;
  END Receive;

  PROCEDURE GetFile*(parent : D.Window; title : ARRAY OF CHAR;
                     VAR full : ARRAY OF CHAR):BOOLEAN;

  VAR
    dlg    : FileDlg;
    string : U.Text;

  BEGIN
    NEW(dlg);
    dlg.Init;
    IF (full="") OR ~Dir.Up(full) THEN
      Dir.GetCurrentDirectory(full);
    END;
    dlg.full.SetString(full);
    dlg.path.SetString(full);
    dlg.SetParent(parent);
    dlg.SetPosition(D.centerOnParent,D.centerOnParent);
    dlg.SetTitle(title);
    dlg.Open;
    dlg.EventLoop;
    dlg.Close;

    IF dlg.result THEN
        string:=dlg.full.GetText();
        COPY(string^,full);
        RETURN TRUE;
    END;

    RETURN FALSE;
  END GetFile;

END VO:Dlg:File.