MODULE VO:LabelPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT Z   := VO:Base:Size,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       F   := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       P   := VO:Panel,
       R   := VO:Radio,
       S   := VO:Space,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                labelPos    : V.IntModel;
                labelAlign  : V.IntModel;
                objectAlign : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Label";

    d.SetPrefs(L.prefs);
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    label  : L.Label;
    radio  : R.Radio;
    frame  : F.FrameGroup;
    panel  : P.Panel;
    space  : S.Space;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    panel:=P.CreateVPanel();

      frame:=F.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Label position");

        label:=L.CreateLabel();
                 
          d.labelPos:=V.CreateIntModel();
          d.labelPos.SetLongint(L.prefs.labelPos);

          radio:=R.CreateRadio();
          radio.SetIndex(L.left);
          radio.SetModel(d.labelPos);
          d.window.AddFocusObject(radio);
        label.AddTextLabel("Left",radio);

          radio:=R.CreateRadio();
          radio.SetIndex(L.right);
          radio.SetModel(d.labelPos);
          d.window.AddFocusObject(radio);
        label.AddTextLabel("Right",radio);
      frame.SetObject(label);
    panel.Add(frame);

      space:=S.CreateVSpace();
    panel.Add(space);

      frame:=F.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Label alignment");

        label:=L.CreateLabel();

          d.labelAlign:=V.CreateIntModel();
          d.labelAlign.Init;
          d.labelAlign.SetLongint(L.prefs.labelAlign);

          radio:=R.CreateRadio();
          radio.SetIndex(L.left);
          radio.SetModel(d.labelAlign);
          d.window.AddFocusObject(radio);
        label.AddTextLabel("Left",radio);

          radio:=R.CreateRadio();
          radio.SetIndex(L.right);
          radio.SetModel(d.labelAlign);
          d.window.AddFocusObject(radio);
       label.AddTextLabel("Right",radio);
      frame.SetObject(label);
    panel.Add(frame);

      space:=S.CreateVSpace();
    panel.Add(space);

      frame:=F.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Object alignment");

        label:=L.CreateLabel();

          d.objectAlign:=V.CreateIntModel();
          d.objectAlign.Init;
          d.objectAlign.SetLongint(L.prefs.objectAlign);

          radio:=R.CreateRadio();
          radio.SetIndex(L.left);
          radio.SetModel(d.objectAlign);
          d.window.AddFocusObject(radio);
        label.AddTextLabel("Left",radio);

          radio:=R.CreateRadio();
          radio.SetIndex(L.right);
          radio.SetModel(d.objectAlign);
          d.window.AddFocusObject(radio);
        label.AddTextLabel("Right",radio);
      frame.SetObject(label);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText(d.name),panel);

    RETURN tab
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.labelPos.SetLongint(L.prefs.labelPos);
    d.labelAlign.SetLongint(L.prefs.labelAlign);
    d.objectAlign.SetLongint(L.prefs.objectAlign);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    L.prefs.labelPos:=p.labelPos.GetLongint();
    L.prefs.labelAlign:=p.labelAlign.GetLongint();
    L.prefs.objectAlign:=p.objectAlign.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    Z.LoadSize("hSpace",top,L.prefs.hSpace);
    Z.LoadSize("hSpace",top,L.prefs.vSpace);

    L.prefs.labelAlign:=top.GetIntEntry("labelAlign",L.prefs.labelAlign);
    L.prefs.objectAlign:=top.GetIntEntry("objectAlign",L.prefs.objectAlign);
    L.prefs.labelPos:=top.GetIntEntry("lablePos",L.prefs.labelPos);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    Z.SaveSize("hSpace",block,L.prefs.hSpace);
    Z.SaveSize("hSpace",block,L.prefs.vSpace);

    block.AddItemInt("labelPos",L.prefs.labelPos);
    block.AddItemInt("labelAlign",L.prefs.labelAlign);
    block.AddItemInt("objectAlign",L.prefs.objectAlign);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:LabelPrefs.