#ifndef S11N_NS_SERIALIZERS_H_INCLUDED
#define S11N_NS_SERIALIZERS_H_INCLUDED 1

////////////////////////////////////////////////////////////////////////////////
// serializers.h
// Includes headers for all serializers shipped with s11n.
// Also handles classloader registration.
//
// License: Public Domain
// Author: stephan@s11n.net
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// The default serializers supported by s11n:
#include "compact_serializer.h" // binary-like grammar
#include "funxml_serializer.h" // robust-yet-simple XML grammar
#include "funtxt_serializer.h" // almost-config-file-style grammar
#include "parens_serializer.h" // compact lisp-like grammar
#include "simplexml_serializer.h" // a simpler XML grammar
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
#include "data_node.h"// reference node implementation.
// data_node.h is ONLY here for purposes of registering
// with the classloader for i/o default handlers,
// not because have a specific dependency on the it.
////////////////////////////////////////////////////////////////////////////////

namespace S11N_NS {
        struct data_node;
        namespace io {
                ////////////////////////////////////////////////////
                // export some friendly names.
                // And document them so doxygen won't bitch. :/
                ////////////////////////////////////////////////////
                /** Short-form name of the base serializer type for s11n::data_node. */
                typedef S11N_NS::io::data_node_serializer<S11N_NS::data_node> base_serializer;
                /** Short-form name of the compact_serializer for s11n::data_node. */
                typedef S11N_NS::io::compact_serializer<S11N_NS::data_node> compact;
                /** Short-form name of the funtxt_serializer for s11n::data_node. */
                typedef S11N_NS::io::funtxt_serializer<S11N_NS::data_node> funtxt;
                /** Short-form name of the funxml_serializer for s11n::data_node. */
                typedef S11N_NS::io::funxml_serializer<S11N_NS::data_node> funxml;
                /** Short-form name of the parens_serializer for s11n::data_node. */
                typedef S11N_NS::io::parens_serializer<S11N_NS::data_node> parens;
                /** Short-form name of the simplexml_serializer for s11n::data_node. */
                typedef S11N_NS::io::simplexml_serializer<S11N_NS::data_node> simplexml;
        }
}

#endif // S11N_NS_SERIALIZERS_H_INCLUDED
