
#ifndef QSFMLCANVAS_HPP
#define QSFMLCANVAS_HPP

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include <SFML/Graphics.hpp>
#include <QWidget>
#include <QTimer>


class QEvent;

////////////////////////////////////////////////////////////
/// QSFMLCanvas allows to run SFML in a Qt control
////////////////////////////////////////////////////////////
class QSFMLCanvas : public QWidget, public sf::RenderWindow
{
public :

    ////////////////////////////////////////////////////////////
    /// Construct the QSFMLCanvas
    ///
    /// \param Size :      Initial size of the widget
    /// \param FrameTime : Frame duration, in milliseconds (0 by default)
    /// \param Parent :    Parent of the widget (NULL by default)
    ///
    ////////////////////////////////////////////////////////////
    QSFMLCanvas(const QSize& Size, unsigned int FrameTime = 0, QWidget* Parent = NULL);

    ////////////////////////////////////////////////////////////
    /// Destructor
    ///
    ////////////////////////////////////////////////////////////
    virtual ~QSFMLCanvas();

private :

    ////////////////////////////////////////////////////////////
    /// Notification for the derived class that moment is good
    /// for doing initializations
    ///
    ////////////////////////////////////////////////////////////
    virtual void OnInit();

    ////////////////////////////////////////////////////////////
    /// Notification for the derived class that moment is good
    /// for doing its update and drawing stuff
    ///
    ////////////////////////////////////////////////////////////
    virtual void OnUpdate();

    ////////////////////////////////////////////////////////////
    /// Return the paint engine used by the widget to draw itself
    ///
    ////////////////////////////////////////////////////////////
    virtual QPaintEngine* paintEngine() const;

    ////////////////////////////////////////////////////////////
    /// Called each time an event is received by the widget ;
    /// we use it to catch the Polish event and initialize
    /// our SFML window
    ///
    ////////////////////////////////////////////////////////////
    virtual bool event(QEvent* Event);

    ////////////////////////////////////////////////////////////
    /// Called when the widget needs to be painted ;
    /// we use it to display a new frame
    ///
    ////////////////////////////////////////////////////////////
    virtual void paintEvent(QPaintEvent*);

    ////////////////////////////////////////////////////////////
    // Member data
    ////////////////////////////////////////////////////////////
    QTimer myTimer; ///< Timer used to update the view
};


#endif // QSFMLCANVAS_HPP
