/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: linkedlist.h,v 1.3 2001/09/29 14:19:23 michael Exp $ */

#ifndef LINKEDLIST_H
#define LINKEDLIST_H 1

#define LINKED_LIST_T(type) \
	struct { \
		type		data; \
	  linked_list_t	*prev; \
		linked_list_t	*next; \
	} 

typedef struct linked_list linked_list_t;

struct linked_list {
        void		*data;
	linked_list_t	*prev;
	linked_list_t	*next;
};

#define LINKED_LIST_ALLOC \
	(void*)linked_list_alloc()
#define LINKED_LIST_FREE(linkedlist) \
	(void*)linked_list_free((linked_list_t**)(linkedlist))
#define	LINKED_LIST_NEXT(linkedlist) \
	(void*)linked_list_next((linked_list_t**)linkedlist)
#define LINKED_LIST_PREV(linkedlist) \
	(void*)linked_list_prev((linked_list_t**)linkedlist)
#define LINKED_LIST_FIRST(linkedlist) \
	(void*)linked_list_first((linked_list_t*)linkedlist)
#define LINKED_LIST_LAST(linkedlist) \
	(void*)linked_list_last((linked_list_t*)linkedlist)
#define LINKED_LIST_ADD(linkedlist, data, len) \
	(void*)linked_list_add((linked_list_t*)linkedlist, (linked_list_t*) data, len)
#define LINKED_LIST_DEL(linkedlist) \
	(void*)linked_list_del((linked_list_t**)linkedlist)
#define LINKED_LIST_PUSH(linkedlist, data, len) \
	(void*)linked_list_push((linked_list_t*)linkedlist, (linked_list_t*)data, len)
#define LINKED_LIST_POP(linkedlist) \
	(void*)linked_list_pop((linked_list_t**)linkedlist)
#define LINKED_LIST_FPUSH(linkedlist, data, len) \
	(void*)linked_list_push((linked_list_t*)linkedlist, (linked_list_t*)data, len)
#define LINKED_LIST_FPOP(linkedlist) \
	(void*)linked_list_pop((linked_list_t**)linkedlist)
#define LINKED_LIST_LEN(linkedlist) \
	linked_list_len((linked_list_t*)linkedlist)

linked_list_t* linked_list_alloc ( );
linked_list_t* linked_list_free ( linked_list_t **linkedlist );
linked_list_t* linked_list_next ( linked_list_t **linkedlist );
linked_list_t* linked_list_prev ( linked_list_t **linkedlist );
linked_list_t* linked_list_first ( linked_list_t *linkedlist );
linked_list_t* linked_list_last ( linked_list_t *linkedlist );
linked_list_t* linked_list_add 
	( linked_list_t *linkedlist, void *data, int len );
linked_list_t* linked_list_del ( linked_list_t **linkedlist );
linked_list_t* linked_list_push 
	( linked_list_t *linkedlist, void *data, int len );
void* linked_list_pop ( linked_list_t **linkedlist );
linked_list_t* linked_list_fpush 
	( linked_list_t *linkedlist, void *data, int len ); 
void* linked_list_fpop ( linked_list_t **linkedlist );
int linked_list_len ( linked_list_t *linkedlist );

#define LINKED_LIST_WALK_BEGIN(linkedlist) \
  do { \
    if (!(linkedlist) || !(linkedlist->data)) \
      break; 

#define LINKED_LIST_WALK_END(linkedlist) \
  } while (LINKED_LIST_NEXT (&linkedlist));

#endif /* LINKEDLIST_H */
