#
# strscan.rb
#
# Copyright (c) 1999-2003 Minero Aoki <aamine@loveruby.net>
#
# This program is free software.
# You can distribute/modify this program under the terms of
# the GNU General Public License version 2 or later.
#

unless defined? ScanError then
  class ScanError < StandardError; end
end

require 'rscan.rb'
begin
  require 'cscan.so'
  StringScanner = StringScanner_C
  class StringScanner
    Revision_C = Id_C.split[2]
    Id = Id_C
    Version = Version_C
    Revision = Revision_C
    Version_R = StringScanner_R::Version_R
    Revision_R = StringScanner_R::Revision_R
  end
rescue LoadError
  StringScanner = StringScanner_R
  class StringScanner
    Id = Id_R
    Version = Version_R
    Revision = Revision_R
    Version_C = nil
    Revision_C = nil
  end
end
