#ifndef TAGCOLL_HANDLE_MAKER_H
#define TAGCOLL_HANDLE_MAKER_H

/*
 * Associate integer handles to strings or other kinds of items
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <map>

namespace Tagcoll
{

template <class T>
class HandleMaker
{
	std::map<int, T> handles_to_items;
	std::map<T, int> items_to_handles;
	int handle_seq;
	
public:
	HandleMaker() throw () : handle_seq(0) {}

	int getHandle(T item) throw ()
	{
		typename std::map<T, int>::iterator i = items_to_handles.find(item);
		if (i == items_to_handles.end())
		{
			int res = handle_seq++;
			items_to_handles.insert(std::make_pair(item, res));
			handles_to_items.insert(std::make_pair(res, item));
			return res;
		} else
			return i->second;
	}

	T getItem(int handle) const throw ()
	{
		typename std::map<int, T>::const_iterator i = handles_to_items.find(handle);
		//assert(i != handles_to_items.end());
		return i->second;
	}
};

};

// vim:set ts=4 sw=4:
#endif
