/*
 * Set of tags and set of facets
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include <tagcoll/TagToString.h>
#include <tagcoll/TagSet.h>

using namespace std;
using namespace Tagcoll;


template<class T>
void StringsToTags<T>::consume(const T& item) throw ()
{
	consumer->consume(item);
}

template<class T>
void StringsToTags<T>::consume(const T& item, const OpSet<std::string>& tags) throw ()
{
	TagSet ntags;
	for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		ntags += vocab.obtainTag(*i);
	consumer->consume(item, ntags);
}

template<class T>
void StringsToTags<T>::consume(const OpSet<T>& items) throw ()
{
	consumer->consume(items);
}

template<class T>
void StringsToTags<T>::consume(const OpSet<T>& items, const OpSet<std::string>& tags) throw ()
{
	TagSet ntags;
	for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		ntags += vocab.obtainTag(*i);
	consumer->consume(items, ntags);
}


template<class T>
void TagsToStrings<T>::consume(const T& item) throw ()
{
	consumer->consume(item);
}

template<class T>
void TagsToStrings<T>::consume(const T& item, const OpSet<Tag>& tags) throw ()
{
	OpSet<string> ntags;
	for (OpSet<Tag>::const_iterator i = tags.begin(); i != tags.end(); i++)
		ntags += i->fullname();
	consumer->consume(item, ntags);
}

template<class T>
void TagsToStrings<T>::consume(const OpSet<T>& items) throw ()
{
	consumer->consume(items);
}

template<class T>
void TagsToStrings<T>::consume(const OpSet<T>& items, const OpSet<Tag>& tags) throw ()
{
	OpSet<string> ntags;
	for (OpSet<Tag>::const_iterator i = tags.begin(); i != tags.end(); i++)
		ntags += i->fullname();
	consumer->consume(items, ntags);
}


// vim:set ts=4 sw=4:
