TEMPLATE = app

# Define your mysql client path
MYSQL_CLIENT = /usr/local/mysql/lib

# =====================================================================
# From this point do not change this pro file
# =====================================================================

CONFIG = warn_on thread rtti exceptions 

# Configure to debug or release
#-------------------------------------------------
isEmpty(TE_PROJECT_TYPE) {
	TE_PROJECT_TYPE=RELEASE
}

contains(TE_PROJECT_TYPE , DEBUG) {
    CONFIG -= release
    CONFIG += debug
}

contains(TE_PROJECT_TYPE , RELEASE) {
    CONFIG += release
}
#-------------------------------------------------


INCLUDEPATH = \
  . \
  .. \
  ../../src/terralib/kernel \
  ../../src/terralib/functions \
  ../../src/terralib/stat \
  ../../src/terralib/utils \
  ../../src/terralib/drivers/shapelib \
  ../../src/terralib/drivers/MySQL \
  ../../src/terralib/drivers/MySQL/include \
  ../../src/terralib/drivers/shapelib \
  ../../src/shapelib \
  ../../src/zlib \
  ../../src/tiff \
  $$INCLUDEPATH

unix {
  OBJECTS_DIR = .obj

  release {
     LIBS += -L../../terralibx/Release
  }
  debug {
     LIBS += -L../../terralibx/Debug
  }

  LIBS += \
    -L/usr/local/lib \
    -L/usr/lib \
    -L$$MYSQL_CLIENT \
    -ljpeg \
    -lshapelib \
    -lz \
    -lterralibtiff \
    -lcrypt \
    -L/usr/lib/mysql -L/usr/local/lib/mysql -L/usr/local/mysql -lmysqlclient \
    -lterralib \
    -lstat
}

win32 {
  CONFIG += console
  DESTDIR = ../Debug
  OBJECTS_DIR = ../Debug
  LIBS += \
    ../../terralibw/shapelib/Debug/shapelib.lib \
    ../../terralibw/stat/Debug/stat.lib \
    ../../terralibw/terralib/Debug/terralib.lib \
    ../../terralibw/tiff/Debug/tiff.lib \
    ../../terralibw/libjpeg/Debug/libjpeg.lib \
    ../../terralibw/OracleSpatial/Oci/Oci.lib \
    ../../terralibw/MySQL/libMySQL.lib \
    ../../terralibw/PostgreSQL/libpq.lib 
}
 
