/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

#ifndef TEPDIGEOMOSAIC_HPP
  #define TEPDIGEOMOSAIC_HPP

  #include "TePDIAlgorithm.hpp"
  #include "TePDIParameters.hpp"
  #include <TeSharedPtr.h>

  /**
   * @brief This is the class for Geographic Mosaic ( geo-referenced rasters )
   * strategy.
   * @author Emiliano F. Castejon <castejon@dpi.inpe.br>
   * @ingroup TePDIMosaicGroup
   *
   * @note The required parameters are:
   * @param blending_type ( std::string ) - Blending type.
   * type ( see TePDIBlendStratFactory documentation for avaliable
   * blending strategies ).   
   * @param input_raster1 ( TePDITypes::TePDIRasterPtrType ) - 
   *  Input raster 1.
   * @param input_raster2 ( TePDITypes::TePDIRasterPtrType ) - 
   *  Input raster 2.
   * @param channels1 ( std::vector< int > ) - The channels to process from 
   * input_raster1.
   * @param channels2 ( std::vector< int > ) - The channels to process from 
   * input_raster2. 
   * @param output_raster ( TePDITypes::TePDIRasterPtrType ) - Output raster.
   *
   * @note The optional parameters are:
   *
   * @param dummy_value (double) - A dummy pixel value for use 
   * in pixels where no data is available.     
   * @param keep_best_res (int) - If present (any value) the best
   * resolution raster will be used as reference.
   * @param auto_equalize ( int ) - If present ( any value ), input_raster2
   * auto-equalizing will be made ( using overlap area reference ).   
   *
   * @note The output_raster parameters will take the choosed reference
   * raster parameters.
   */
  class PDI_DLL TePDIGeoMosaic : public TePDIAlgorithm {
    public :
      
      /**
       * @brief Default Constructor.
       *
       */
      TePDIGeoMosaic();

      /**
       * @brief Default Destructor
       */
      ~TePDIGeoMosaic();
      
      /**
       * @brief Checks if the supplied parameters fits the requirements of 
       * each PDI algorithm implementation.
       *
       * @note Error log messages must be generated. No exceptions generated.
       *
       * @param parameters The parameters to be checked.
       * @return true if the parameters are OK. false if not.
       */
      bool CheckParameters( const TePDIParameters& parameters ) const;      

    protected :
    
      /**
       * @brief Reset the internal state to the initial state.
       *
       * @param params The new parameters referente at initial state.
       */
      void ResetState( const TePDIParameters& params );    
     
      /**
       * @brief Runs the current algorithm implementation.
       *
       * @return true if OK. false on error.
       */
      bool RunImplementation();      
  };
  
/** @example TePDIMosaic_test.cpp
 *    Shows how to use this class.
 */    

#endif
