# Configure paths for TI68K
# Romain Lievin  01-11-07 (taken from glib.m4)

dnl AM_PATH_TI68K([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for TI68K, and define TI68K_CFLAGS and TI68K_LIBS, if "gmodule" or 
dnl gthread is specified in MODULES, pass to ti68k-config
dnl
AC_DEFUN(AM_PATH_TI68K,
[dnl 
dnl Get the cflags and libraries from the ti68k-config script
dnl
AC_ARG_WITH(ti68k-prefix,[  --with-ti68k-prefix=PFX   Prefix where TI68K is installed (optional)],
            ti68k_config_prefix="$withval", ti68k_config_prefix="")
AC_ARG_WITH(ti68k-exec-prefix,[  --with-ti68k-exec-prefix=PFX Exec prefix where TI68K is installed (optional)],
            ti68k_config_exec_prefix="$withval", ti68k_config_exec_prefix="")
AC_ARG_ENABLE(ti68ktest, [  --disable-ti68ktest       Do not try to compile and run a test TI68K program],
		    , enable_ti68ktest=yes)

  if test x$ti68k_config_exec_prefix != x ; then
     ti68k_config_args="$ti68k_config_args --exec-prefix=$ti68k_config_exec_prefix"
     if test x${TI68K_CONFIG+set} != xset ; then
        TI68K_CONFIG=$ti68k_config_exec_prefix/bin/ti68k-config
     fi
  fi
  if test x$ti68k_config_prefix != x ; then
     ti68k_config_args="$ti68k_config_args --prefix=$ti68k_config_prefix"
     if test x${TI68K_CONFIG+set} != xset ; then
        TI68K_CONFIG=$ti68k_config_prefix/bin/ti68k-config
     fi
  fi

  for module in . $4
  do
      case "$module" in
         gmodule) 
             ti68k_config_args="$ti68k_config_args gmodule"
         ;;
         gthread) 
             ti68k_config_args="$ti68k_config_args gthread"
         ;;
      esac
  done

  AC_PATH_PROG(TI68K_CONFIG, ti68k-config, no)
  min_ti68k_version=ifelse([$1], ,0.99.7,$1)
  AC_MSG_CHECKING(for TI68K - version >= $min_ti68k_version)
  no_ti68k=""
  if test "$TI68K_CONFIG" = "no" ; then
    no_ti68k=yes
  else
    TI68K_CFLAGS=`$TI68K_CONFIG $ti68k_config_args --cflags`
    TI68K_LIBS=`$TI68K_CONFIG $ti68k_config_args --libs`
    ti68k_config_major_version=`$TI68K_CONFIG $ti68k_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    ti68k_config_minor_version=`$TI68K_CONFIG $ti68k_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    ti68k_config_micro_version=`$TI68K_CONFIG $ti68k_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_ti68ktest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $TI68K_CFLAGS"
      LIBS="$TI68K_LIBS $LIBS"
dnl
dnl Now check if the installed TI68K is sufficiently new. (Also sanity
dnl checks the results of ti68k-config to some extent
dnl
      rm -f conf.ti68ktest
      AC_TRY_RUN([
#include <ti68k.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.ti68ktest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_ti68k_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_ti68k_version");
     exit(1);
   }

  if ((ti68k_major_version != $ti68k_config_major_version) ||
      (ti68k_minor_version != $ti68k_config_minor_version) ||
      (ti68k_micro_version != $ti68k_config_micro_version))
    {
      printf("\n*** 'ti68k-config --version' returned %d.%d.%d, but TI68K (%d.%d.%d)\n", 
             $ti68k_config_major_version, $ti68k_config_minor_version, $ti68k_config_micro_version,
             ti68k_major_version, ti68k_minor_version, ti68k_micro_version);
      printf ("*** was found! If ti68k-config was correct, then it is best\n");
      printf ("*** to remove the old version of TI68K. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If ti68k-config was wrong, set the environment variable TI68K_CONFIG\n");
      printf("*** to point to the correct copy of ti68k-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
  else if ((ti68k_major_version != TI68K_MAJOR_VERSION) ||
	   (ti68k_minor_version != TI68K_MINOR_VERSION) ||
           (ti68k_micro_version != TI68K_MICRO_VERSION))
    {
      printf("*** TI68K header files (version %d.%d.%d) do not match\n",
	     TI68K_MAJOR_VERSION, TI68K_MINOR_VERSION, TI68K_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     ti68k_major_version, ti68k_minor_version, ti68k_micro_version);
    }
  else
    {
      if ((ti68k_major_version > major) ||
        ((ti68k_major_version == major) && (ti68k_minor_version > minor)) ||
        ((ti68k_major_version == major) && (ti68k_minor_version == minor) && (ti68k_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of TI68K (%d.%d.%d) was found.\n",
               ti68k_major_version, ti68k_minor_version, ti68k_micro_version);
        printf("*** You need a version of TI68K newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** TI68K is always available from ftp://ftp.gtk.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the ti68k-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of TI68K, but you can also set the TI68K_CONFIG environment to point to the\n");
        printf("*** correct copy of ti68k-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_ti68k=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_ti68k" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$TI68K_CONFIG" = "no" ; then
       echo "*** The ti68k-config script installed by TI68K could not be found"
       echo "*** If TI68K was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the TI68K_CONFIG environment variable to the"
       echo "*** full path to ti68k-config."
     else
       if test -f conf.ti68ktest ; then
        :
       else
          echo "*** Could not run TI68K test program, checking why..."
          CFLAGS="$CFLAGS $TI68K_CFLAGS"
          LIBS="$LIBS $TI68K_LIBS"
          AC_TRY_LINK([
#include <ti68k.h>
#include <stdio.h>
],      [ return ((ti68k_major_version) || (ti68k_minor_version) || (ti68k_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding TI68K or finding the wrong"
          echo "*** version of TI68K. If it is not finding TI68K, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the GTK package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps gtk gtk-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means TI68K was incorrectly installed"
          echo "*** or that you have moved TI68K since it was installed. In the latter case, you"
          echo "*** may want to edit the ti68k-config script: $TI68K_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     TI68K_CFLAGS=""
     TI68K_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(TI68K_CFLAGS)
  AC_SUBST(TI68K_LIBS)
  rm -f conf.ti68ktest
])
