/*  gtktiemu - a TI89/92/92+ emulator
 *  (c) Copyright 2000-2001, Romain Lievin and Thomas Corvazier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "intl.h"

#include <stdlib.h>
#include "sysdeps.h"

#include <stdio.h>
#ifndef __WIN32__
#include <dirent.h>
#endif
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>

#include "packets.h"
#include "cmdinterface.h"
#include "memory.h"
#include "config.h"
#include "options.h"
#include "newcpu.h"
#include "hardware.h"
#include "globinfo.h"
#include "lib68k.h"
#include "platform.h"


char *varNames[48] =
{
  "EXPR", "UNKNOWN", "UNKNOWN", "UNKNOWN", "LIST", "UNKNOWN", "MAT", "UNKNOWN",
  "UNKNOW", "UNKNOWN", "DATA", "TEXT", "STR", "GDB", "FIG", "UNKNOWN",
  "PIC", "UNKNOWN", "PRGM", "FUNC", "MAC", "UNKNOWN", "UNKNOWN", "UNKNOWN",
  "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "ZIP", "BACKUP", "UNKNOWN", "DIR",
  "UNKNOWN", "ASM", "IDLIST", "UNKNOWN", "FLASH", "UNKNOWN", "LOCKED", "ARCHIVED",
  "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN"
};


char fname[64];
int linkType = 0;
int progBar = 0;
int totalSize = 0;
int cmdState = 0;
tifile dirBuffer[64];
char currDir[128] = "";

int do_command(unsigned char *cmd, unsigned char *arg1);
void prompt_commands(void);
void print_dir(void);


void cmd_update_progbar(int size) 
{
  static int cnt = 0;
  if((cnt++)&1) 
    {
      DISPLAY(".");
      fflush(stdout);
    }
}

void cmd_link_progress(int type, char *name, int size) 
{
  switch(type) 
    {
    case LINK_RUNNING:
      if(progBar)
	cb_update_progbar(size);
      break;
    case LINK_FAIL:
    case LINK_STOP:
      speedyLink = 0;
      if(cmdState) 
	{
	  if(type == LINK_FAIL) 
	    {
	      DISPLAY(_("\nTransaction failed.\n"));
	    }
	  else 
	    {
	      if(linkType == LINK_DIR)
		print_dir();
	      else
		DISPLAY(_("\nTransaction complete.\n"));
	    }
	  linkType = progBar = 0;	 
	  prompt_commands();
	}
      break;
    default:
      if(type == LINK_BACKUP)
	progBar = 1;
      linkType = type;
      totalSize = size;
    }
}

int getOut = 0;

void print_dir(void)
{
  int i = 0;
  while(dirBuffer[i].type != 255)
    {
      if(dirBuffer[i].type == 0x1f)
        DISPLAY("\n[%s]\n", dirBuffer[i].name);
      else
        DISPLAY("  %-012s %-4s %d\n", dirBuffer[i].name, 
	       varNames[dirBuffer[i].type], dirBuffer[i].size);
      i++;
    }
}

int do_command(unsigned char *cmd, unsigned char *arg1) 
{    
#ifdef __LINUX__
	if(cmdState) 
    {
      if(!(strcmp(cmd, "ls"))) 
	{
	  char ext[4];
	  struct stat aStat;
	  struct dirent *dent;
	  DIR *dir = opendir(currDir);

	  DISPLAY("%s\n", currDir);
	  while((dent = readdir(dir))) 
	    {
	      strcpy(ext, &dent->d_name[strlen(dent->d_name)-3]); 
	      ext[2] = toupper(ext[2]);
	      stat(dent->d_name, &aStat);
	      if(S_ISDIR(aStat.st_mode))
		DISPLAY("  [%s]\n", dent->d_name);
	      else
		if(!strcmp(ext, "92P") || !strcmp(ext, "92B"))
		  DISPLAY("  %-32s %d\n", dent->d_name, (int)(aStat.st_size));
	    }
	  closedir(dir);
	}
      else
	if(!(strcmp(cmd, "cd"))) 
	  {
	    if(arg1)  
	      {
		if(chdir(arg1))
		  DISPLAY(_("\nIllegal directory!\n"));
		else
		  DISPLAY(_("\nCurrent directory changed to:\n%s\n"), 
			  getcwd(currDir, sizeof(currDir)));
	      }
	    else
	      DISPLAY(_("\nCurrent directory is:\n%s\n"), currDir);
	  }
	else
	  if(!(strcmp(cmd, "dirlist"))) 
	    {
	      // depends on packet.c
	      //start_get_directory(dirBuffer, 64);
	      getOut = 1;
	    }
	  else
	    if(!(strcmp(cmd, "quit") || !strcmp(cmd, "exit"))) 
	      {
		cmdState = 0;
		//cb_screen_on();
		getOut = 1;
	      }
	    else
	      if(!(strcmp(cmd, "load"))) 
		{
		  /*
		  if(!send_ti_file(arg1))
		    DISPLAY(_("File not found\n"));
		  else
		    getOut =1;
		 */
		}
	      else
		if(!(strcmp(cmd, "help"))) 
		  {
		    DISPLAY(_("Currently recognized commands:\nload[ti_file], dirlist, ls, cd, help, quit\n"));
		  }
      
    }
#endif
  return 0;  
}

void prompt_commands(void) 
{
  char *cmd, *arg1, *arg2;
  char line[80];
  
  getOut = 0;
  while(!getOut) 
    {   
      DISPLAY(_("\ncmd >"));
      fgets(line, 80, stdin);
      line[strlen(line)-1]='\0'; //strap LF
      cmd = strtok(line, " ");
      arg1 = strtok(NULL, " ");
      arg2 = strtok(NULL, " ");
      if(cmd)
	do_command(cmd, arg1);
    }
}

void enter_command(void) 
{
  if(!strlen(currDir))
    getcwd(currDir, sizeof(currDir));
  
  DISPLAY(_("Commandstate entered. \"quit\" to quit.\n"));
  cmdState = 1;
  prompt_commands();
}

