/*  gtktiemu - a TI89/92/92+ emulator
 *  (c) Copyright 2000, Romain Lievin and Thomas Corvazier
 *  (c) Copyright 2001, Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//#ifndef __MEMORY__
//#define __MEMORY__

#include "intlist.h"

//------- flashrom
extern int flash_protect;
extern int rom_ret_or;
extern int rom_write_ready;
extern int rom_write_phase;
extern int rom_erase;
extern int rom_erasePhase;

extern void extRomWriteByte(int adr, int v);
extern void intRomWriteByte(int adr, int v);
//-------
extern int mem_init(void);
extern void mem_exit(void);
extern UBYTE get_byte(CPTR adr);
extern UWORD get_word(CPTR adr);
extern ULONG get_long(CPTR adr);
extern void put_long(CPTR adr, ULONG arg);
extern void put_word(CPTR adr, UWORD arg);
extern void put_byte(CPTR adr, UBYTE arg);

extern UBYTE io_get_byte(CPTR adr);
extern UWORD io_get_word(CPTR adr);
extern ULONG io_get_long(CPTR adr);
extern void io_put_long(CPTR adr, ULONG arg);
extern void io_put_word(CPTR adr, UWORD arg);
extern void io_put_byte(CPTR adr, UBYTE arg);

extern UBYTE *get_real_address(CPTR adr);
extern int valid_address(CPTR adr, ULONG size);

extern int buserr;

extern UBYTE *ti_ram;
extern UBYTE *ti_rom, *ti_int_rom, *ti_ext_rom;
extern UBYTE *ti_io;

extern UBYTE *mem_tab[8];
extern ULONG mem_mask[8];

extern int breakMode;
extern int breakType;
extern int breakId;

extern struct intlist *listBkptAsRB;  extern int nBkptAsRB;
extern struct intlist *listBkptAsWB;  extern int nBkptAsWB;
extern struct intlist *listBkptAsRW;  extern int nBkptAsRW;
extern struct intlist *listBkptAsWW;  extern int nBkptAsWW;
extern struct intlist *listBkptAsRL;  extern int nBkptAsRL;
extern struct intlist *listBkptAsWL;  extern int nBkptAsWL;
extern struct intlist *listBkptAsRgR; extern int nBkptAsRgR;
extern struct intlist *listBkptAsRgW; extern int nBkptAsRgW;


/* Banks sizes. Must be a power of two */
extern int RAM_SIZE;
extern int ROM_SIZE;
extern int IO_SIZE;

#define rom_at_0() {mem_tab[0] = ti_rom; mem_mask[0] = ROM_SIZE-1;}
#define ram_at_0() {mem_tab[0] = ti_ram; mem_mask[0] = RAM_SIZE-1;}

//#endif
