#
# execute runit test in T/
#

require 'runit/testsuite'
require 'runit/testcase'
require 'runit/cui/testrunner'
$:.unshift '../..'


module RUNIT

  @tmp = []

  class << self
    def load( fname, methods = nil )
      @tmp.push [nil, methods]
      require fname
    end

    def add_test_case( klass )
      @tmp[-1][0] = klass
    end

    def exec
      suite = TestSuite.new
      @tmp.each do |klass, methods|
        if methods then
          methods.each do |i|
            suite.add_test klass.new( 'test_' + i )
          end
        else
          suite.add_test klass.suite
        end
      end
      RUNIT::CUI::TestRunner.quiet_mode = true
      f = File.open('/dev/tty', 'w')
      f.sync = true
      RUNIT::CUI::TestRunner.new(f).run suite
    end
  end

end

class Module
  def testme!
    RUNIT.add_test_case self
  end
end


unless File.basename(Dir.pwd) == 'T' then
  Dir.chdir 'T'
end

if ARGV.empty? then
  Dir['./test*.rb'].each do |fname|
    RUNIT.load fname
  end
else
  ARGV.each do |i|
    name, m = i.split('.', 2)
    methods = m.split(',') if m

    RUNIT.load "test#{name}.rb", methods
  end
end
RUNIT.exec
