//
// Include da aggiungere in tutti i programmi
// 
#include "finestre.h"
//
// Definizione Variabili esterne
// 


// Converts a hexadecimal string to integer
int xtoi(const char* xs, unsigned int* result)
{
 size_t szlen = strlen(xs);
 int i, xv, fact;

 if (szlen > 0)
 {
  // Converting more than 32bit hexadecimal value?
  if (szlen>8) return 2; // exit

  // Begin conversion here
  *result = 0;
  fact = 1;

  // Run until no more character to convert
  for(i=szlen-1; i>=0 ;i--)
  {
   if (isxdigit(*(xs+i)))
   {
    if (*(xs+i)>=97)
    {
     xv = ( *(xs+i) - 97) + 10;
    }
    else if ( *(xs+i) >= 65)
    {
     xv = (*(xs+i) - 65) + 10;
    }
    else
    {
     xv = *(xs+i) - 48;
    }
    *result += (xv * fact);
    fact *= 16;
   }
   else
   {
    // Conversion was abnormally terminated
    // by non hexadecimal digit, hence
    // returning only the converted with
    // an error value 4 (illegal hex character)
    return 4;
   }
  }
 }

 // Nothing to convert
 return 1;
}

int trap (CmdInfo *cmd, int EventType, char *par)
{
    static unsigned int colorbg,colorfg;
    unsigned int color=0;

    //printf ("cmd=%s EventType=%d par=%s\n",cmd->Label,EventType,par);

    if ((!colorbg && !colorfg) || EventType==Button1Press)
    {
        colorbg=WX11_ColorGet (WINBG);
        colorfg=WX11_ColorGet (WINFG);
    }

    if (EventType==EnterNotify)
    {
        xtoi(&cmd->Label[26],&color);

        if (!strcmp (par,"WinBg"))
        {
            WX11_ColorSet (WINBG,color);
            WX11_ColorSet (BUTTONBG,color);
            WX11_ColorSet (LISTBOXBG,color);
            WX11_ColorSet (INPUTBG,color);
        }
        if (!strcmp (par,"WinFg"))
        {
            WX11_ColorSet (WINFG,color);
            WX11_ColorSet (BUTTONFG,color);
            WX11_ColorSet (LISTBOXFG,color);
            WX11_ColorSet (INPUTFG,color);
        }

        WX11_ColorChange (NULL);
    }

    if (EventType==LeaveNotify)
    {
        WX11_ColorSet (WINBG,colorbg);
        WX11_ColorSet (BUTTONBG,colorbg);
        WX11_ColorSet (LISTBOXBG,colorbg);
        WX11_ColorSet (INPUTBG,colorbg);

        WX11_ColorSet (WINFG,colorfg);
        WX11_ColorSet (BUTTONFG,colorfg);
        WX11_ColorSet (LISTBOXFG,colorfg);
        WX11_ColorSet (INPUTFG,colorfg);

        WX11_ColorChange (NULL);

    }


	return (0);
}
void CaricaColori (ListCmdInfo *Lista)
{
    char BUFF[64];
    char *pbuff;
	
    FILE *in;

    in = fopen(FullPath("../include/colori.h"), "r");
    if (in)
    {
        while (!feof(in))
        {
            if (fgets(BUFF, sizeof(BUFF), in)!=NULL)
            {
                BUFF[strlen(BUFF)-1]='\0';
				
                if (strncmp (BUFF,"#define ",8)==0)
                {
                    pbuff=BUFF;
                    pbuff=pbuff+8;
                    if (BUFF)
                    {
                        WX11_ListCmdItemAdd (Lista, COMBO_BOX, TabulazioniRiga(pbuff));
                    }
                }
            }
        }
        fclose (in);
    }
}

int main (int argc, char **argv)
{
	CmdInfo *mio;
        ListCmdInfo *ListaColoriWinFg,*ListaColoriWinBg;

        char Colore_WINFG[64];
        char Colore_WINBG[64];



	InitFinestre (argc, argv);

 

	mio=ApreFinestraCentrale ("Gestione Colori", 600, 450);

	ListaColoriWinBg=WX11_ListCmdAdd ("ColoriWinBG");
        WX11_SetSignalCallBack (ListaColoriWinBg,EnterNotify,trap,"WinBg");
        WX11_SetSignalCallBack (ListaColoriWinBg,LeaveNotify,trap,"WinBg");
        WX11_SetSignalCallBack (ListaColoriWinBg,Button1Press,trap,"WinBg");

	ListaColoriWinFg=WX11_ListCmdAdd ("ColoriWinFG");
        WX11_SetSignalCallBack (ListaColoriWinFg,EnterNotify,trap,"WinFg");
        WX11_SetSignalCallBack (ListaColoriWinFg,LeaveNotify,trap,"WinFg");
        WX11_SetSignalCallBack (ListaColoriWinFg,Button1Press,trap,"WinFg");

        CaricaColori(ListaColoriWinBg);
	CaricaColori(ListaColoriWinFg);

        WX11_Say (mio,"\nHello World!\n\n");

        WX11_ComboBox (mio,ListaColoriWinBg, 200,200, "Window Bg:",Colore_WINBG,sizeof(Colore_WINBG));

        WX11_Say (mio,"\n\n\n");

        WX11_ComboBox (mio,ListaColoriWinFg, 200,200, "Window Fg:",Colore_WINFG,sizeof(Colore_WINFG));

	WX11_Events (mio);	

	//Free

	WX11_CloseDisplay();

	return (0);
}

