/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.LiteralExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

class DecodeURIFunction
implements Function {
    static String dfltEncName = "UTF-8";

    DecodeURIFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
        if (args.length < 1 || args.length > 2) {
            throw new ParseException("expected 1 or 2 arguments");
        }
        final ConvertibleStringExpr se = args[0].makeStringExpr();
        final ConvertibleStringExpr se2 = args.length == 1 ? new LiteralExpr("") : args[1].makeStringExpr();
        return new ConvertibleStringExpr(){

            public String eval(Node node, ExprContext context) throws XSLException {
                return DecodeURIFunction.decodeURI(se.eval(node, context), se2.eval(node, context));
            }
        };
    }

    private static final String decodeURI(String src, String enc) {
        try {
            if ("".equals(enc)) {
                enc = dfltEncName;
            }
            return URLDecoder.decode(src, enc);
        }
        catch (UnsupportedEncodingException uex) {
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }
}

