/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file ParameterSettings.cc
    \brief Implementation of parameter settings.
    \author Graphics Section, ECMWF

    Started: 2004

*/
#include <ParameterSettings.h>

void buildkeys(const vector<string>& roots, const string& name, vector<string>& keys)
{
	keys.push_back(name);

	for (vector<string>::const_iterator root = roots.begin(); root != roots.end(); ++root)
	{
		string x = name;
		string::size_type index = x.find(*root);

		if ( index != string::npos)
		{
			x.replace(index, (*root).length()+1, "");
			keys.push_back(x);		
		}
	}
}

void setAttribute(const vector<string>& roots, const string& name, string& param, const map<string, string>& params)
{
	vector<string> keys;	
	buildkeys(roots, name, keys);

	map<string, string>::const_iterator val;
	for (vector<string>::const_iterator key = keys.begin(); key != keys.end(); ++key)
	{
		val = params.find(*key);

		if ( val == params.end() ) continue;
		Log::debug() << "Parameter [" << name << "] set to " << val->second << endl;
		param = val->second;
	}
}

void setAttribute(const vector<string>& roots, const string& name, auto_ptr<Colour>& param, const map<string, string>& params)
{
	vector<string> keys;	
	buildkeys(roots, name, keys);

	map<string, string>::const_iterator val;
	for (vector<string>::const_iterator key = keys.begin(); key != keys.end(); ++key)
	{
		val = params.find(*key);
		if ( val == params.end() ) continue;
		Log::debug() << "Parameter [" << name << "] set to " << val->second << endl;
		param = auto_ptr<Colour>(new Colour(val->second));
	}
}
