/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GraphShade.h
    \brief Definition of the Template class GraphShade.
    
    Magics Team - ECMWF 2006
    
    Started: Thu 17-Aug-2006
    
    Changes:
    
*/

#ifndef GraphShade_H
#define GraphShade_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"
#include "BasicGraphicsObject.h"
#include "GraphShadeAttributes.h"
#include "CustomisedPoint.h"

namespace magics {

class Polyline;
class PaperPoint;
class UserPoint;

class GraphShade : public GraphShadeAttributes{

public:
	GraphShade();
	virtual ~GraphShade();
    
    virtual void set(const XmlNode& node) {
       GraphShadeAttributes::set(node);
    }
    virtual void set(const map<string, string>& map) {
        GraphShadeAttributes::set(map);
    }
    virtual GraphShade* clone() const {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
        return new GraphShade();
    }
  
    virtual void operator()(Polyline&); 
    virtual void legend(Polyline&); 
    virtual void operator()(CustomisedPointsList&, vector<UserPoint>&); 
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	GraphShade(const GraphShade&);
    //! Overloaded << operator to copy - No copy allowed
	GraphShade& operator=(const GraphShade&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const GraphShade& p)
		{ p.print(s); return s; }

};

class NoGraphShade : public GraphShade {

public:
	NoGraphShade() {}
	virtual ~NoGraphShade() {}
    
    virtual void set(const XmlNode&) {}
    virtual void set(const map<string, string>&) {}
    virtual GraphShade* clone() const {      
        return new NoGraphShade();
    }
    
     virtual void operator()(Polyline&) {}
     virtual void legend(Polyline&) {}
     void operator()(CustomisedPointsList&, vector<UserPoint>&); 
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 


};


template <>
class Translator<string, GraphShade> { 
public:
	GraphShade* operator()(const string& val )
	{
		return SimpleObjectMaker<GraphShade>::create(val);
	}     

	GraphShade* magics(const string& param)
	{
		GraphShade* object;
		ParameterManager::update(param, object);
		return object;
	}
};

} // namespace magics
#endif
