// Checker.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef CHECKER_HH
#define CHECKER_HH

#include <vector>
#include <string>
#include "Header.hh"
#include "RegExp.hh"
#include "Preferences.hh"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

using namespace std;

namespace check {
  
  class Checker {
  private:
    string matchString;
    string matchFilter;
    pref::Preferences* prefs;
    re::RegExp regExp;

  public:
    Checker(pref::Preferences*);
    ~Checker();
    int duplicates(msg::Header*, vector<string>*);
    int lineLength(msg::Header*);
    int friends(msg::Header*);
    int size(msg::Header*);
    int filters(msg::Header*);
    int negFilters(msg::Header*);

    void setMatchingString(const string);
    string matchingString(void);
    void setMatchingFilter(const string);
    string matchingFilter(void);
  };

}

#endif
