// RFC822.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef RFC822_HH
#define RFC822_HH

#include <string>
#include "Header.hh"

using namespace std;

// Further details:  http://www.faqs.org/rfcs/rfc822.html
// STANDARD FOR THE FORMAT OF ARPA INTERNET TEXT MESSAGES

namespace rfc {

  class RFC822 {
  public:
    RFC822();
    ~RFC822();
    msg::Header extract(const string&, int, int, bool);
    string normalise(const string&);
  };
  
  // Exceptions
  class MalformedHeader{};

}

#endif
