// Header.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2004  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef __HEADER_HH_
#define __HEADER_HH_

#include <string>
#include <vector>

using namespace std;

namespace msg {

  // Class for a _single_ line of a header
  class Line {
  private:
    string field;
    string contents;
  
  public:
    const string& descr(void);
    void setDescr(const string&);
    const string& content(void);
    void setContent(const string&);
  };
  
  // Class for an entire header
  class Header { 
  private:
    // Basic information on the e-mail message header
    int nr;                         // Nr. of message
    int bytes;                      // Size of message
    vector<Line> content;           // Each line of the message header
    
    // We store those values seperately so it's easier to log the information:
    string sndr;                    // Sender
    string subj;                    // Subject
    string dat;                     // Date
    string msgID;                   // Message ID
    string nSubject;                // Normalised subject string

  public:
    Header();
    ~Header();

    // Accessor functions
    int number(void);
    void setNumber(int);
    int size(void);
    void setSize(int);
    const vector<Line>& lines(void);
    void addLine(const Line&);
    const string& sender(void);
    void setSender(const string&);
    const string& subject(void);
    void setSubject(const string&);
    const string& date(void);
    void setDate(const string&);
    const string& messageID(void);
    void setMessageID(const string&);
    const string& normalSubject(void);
    void setNormalSubject(const string&);
  };

}

#endif
