/* ============================================================
 *
 * Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>
 * Copyright (C) 2007 Frode M. Døving <frode@lnix.net>
 *
 * Orginal copied from digikam: Leonid Zeitlin <lz@europe.com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef DCOPIFACE_H
#define DCOPIFACE_H

// Qt includes.

#include <qobject.h>
#include <dcopobject.h>

/**
* This class implements a DCOP interface for Mailody.
* At the moment it supports mailto links
*
* @short DCOP interface for Mailody
* @author Leonid Zeitlin, Tom Albers, Frode M. Døving
*/

class DCOPIface : public QObject, public DCOPObject
{
    K_DCOP
    Q_OBJECT

public:

    /**
     * Standard constructor.
     * @param parent Parent object reference, passed to QObject constructor
     * @param name Specifis the name of the object, passed to QObject constructor
     */
    DCOPIface(QObject *parent = 0, const char *name = 0);

    /**
     * Standard destructor
    */
    ~DCOPIface();

signals:

    /**
     * This signal is emitted when @ref mailTo() is called via DCOP
     * @param address to send an email to
     */
    void signalMailTo( const QString& address);

    /**
     * This signal is emitted when @ref compose() is called via DCOP
     * Opens a composer with:
     * @param files attached.
     * @param addr as recipient.
     */
     void signalCompose(
                        const QString& addr=QString::null,
                        const QString& files=QString::null
                        );

public:

k_dcop:
    /**
     * These methods can be called via DCOP.
     */
    ASYNC mailTo( const QString& );
    ASYNC compose( const QString&, const QString& );
    ASYNC attach( const QString& );
};

#endif // DCOPIFACE_H
