#!/usr/bin/perl

# Copyright (c) Kim Holviala <kimmy@iki.fi> 1997-2000

require 5.002;


# Misc. functions ===========================================================

# _THE_ note ----------------------------------------------------------------

sub bigNote {

	redirect('http://mailreader.com/download/readme.html');
        exit;
}


# Send message delivery notification ----------------------------------------

sub sendDeliveryNote {

	($header, $action) = @_;

# Create boundary
	$t = time;
	$boundary = "===cLiP..cLaP..cLiP..cLaP===${t}$$===";

# Print message to a temporary file
	$filename = &getRandomFilename('SMTP');

	open(FILE, ">$CONFIG{'SMTPPath'}$filename");
	binmode FILE if $WinNT;

# Print header
	$header =~ /^Disposition-Notification-To:\s*(.*)/mi;
	$to = $1;

	print FILE
		"To: $to$crlf",
		"From: $CONFIG{'RealName'} <$CONFIG{'RealEmail'}>$crlf",
		"Subject: Disposition notification$crlf",
		"Date: ", &getDate, $crlf,
		"X-Mailer: Mailreader.com $CONFIG{'SoftwareVersion'}$crlf",
		"Message-ID: <jUsT.aNoTheR.mEsSaGe.iD.", time, $$, "\@$CONFIG{'ServerName'}>$crlf",
		"MIME-Version: 1.0$crlf",
		"Content-Type: multipart/report; report-type=disposition-notification;",
		"${crlf}        boundary=\"$boundary\"$crlf$crlf",
		"This is a multi-part message in MIME format.$crlf$crlf",
		"--$boundary$crlf",
		"Content-Type: text/plain; charset=iso-8859-1$crlf",
		"Content-Transfer-Encoding: 8bit$crlf$crlf";
     
# Print clear-text notification
	$subject = $header =~ /^Subject:\s*(.*)/mi ? $1 : '(Unknown)';
	$date = $header =~ /^Date:\s*(.*)/mi ? $1 : '(Unknown date)';

	if ($action eq 'read') {
		print FILE "The message sent on $date with subject \"$subject\" has been displayed ",
			"to $CONFIG{'RealName'} <$CONFIG{'RealEmail'}>. ",
			"This is no guarantee that the message has been read or understood.$crlf$crlf";
	}
	else {
		print FILE "The message sent on $date with subject \"$subject\" has been deleted ",
			"by $CONFIG{'RealName'} <$CONFIG{'RealEmail'}>. ",
			"The recipient may or may not have seen the message. The recipient ",
			"might \"undelete\" the message at a later time and read the message.$crlf$crlf";
	}

# Print machine-readable notification
	$msgid = $header =~ /^Message-ID:\s*(.*)/mi ? $1 : '';

	print FILE "--$boundary$crlf",
		"Content-Type: message/disposition-notification$crlf$crlf",
		"Reporting-UA: $CONFIG{'RemoteHost'}; Mailreader.com $CONFIG{'SoftwareVersion'}$crlf",
		"Final-Recipient: rfc822;$CONFIG{'RealEmail'}$crlf",
		($msgid and "Original-Message-ID: $msgid$crlf"),
		"Disposition: manual-action/MDN-sent-automatically; ",
		($action eq 'read' ? 'displayed' : 'deleted'), "$crlf$crlf";

# Print headers of da original message
	$header =~ s/^<\/*X-MAILREADER.*?>.*\n//gm;
	$header =~ s/^(Content-Type|Disposition-Notification-To):.*\n//gim;

	print FILE "--$boundary$crlf",
		"Content-Type: message/rfc822$crlf$crlf",
		"$header$crlf$crlf$crlf--$boundary--$crlf";

# Close and send message
	close FILE;	

	&loadModule('network.cgi');
	&forkProcess('&mailFile("$CONFIG{\'SMTPPath\'}$filename");');
}


# Save password (remote login) ----------------------------------------------

sub savePassword {
	$file = &getRandomFilename;

	open(FILE, ">$CONFIG{'TempPath'}$file");
	print FILE $FORM{'password'};
	close(FILE);

	&httpHeaders;
	print "Content-Type: application/x-whatever${crlf}${crlf}$file";

	exit;
}


# Help for the loginpage ----------------------------------------------------

sub loginHelp {
	&advertisement;

	$_ = &getTemplate('loginhelp.html');
	s/<!--begin-->/&getTemplate("$CONFIG{'Language'}.help")/e;

	&httpHeaders;
	print "Content-Type: text/html$crlf$crlf$_\n";

	exit;
}


# Show a printable version of a message -------------------------------------

sub printable {

# Print headers
	&httpHeaders;

# Get da message & da template
	$msg = $FORM{'msg'};
	&getMessage($msg);
	&getMsgNumbers($msg);

	$_ = &getTemplate('printable.html');

# Do stuff
	$message =~ s/\{(\w+?)\}/&config($1)/ge;
	$message =~ s/<X-MAILREADER-HEADER>(.|\n)*?<\/X-MAILREADER-HEADER>/&prepareHeader($&, $msg, 1)/ge;

	$message = "<A HREF=\"$CONFIG{'ScriptName'}?do=read\&msg=$msg\&$CONFIG{'LinkQueryString'}\">" .
		"$CONFIG{'TButtonStart'}$CONFIG{'TextBackToMessage'}$CONFIG{'TButtonEnd'}</A><P>\n$message";

	s/<!--begin-->/$message/;

# Print the page
	print "Content-Type: text/html$crlf$crlf$_\n";

	exit;
}


# Show help -----------------------------------------------------------------

sub showHelp {

# Get & format the helpfile
	&advertisement;
	$_ = &getTemplate("$FORM{'size'}help.html");

# Handle small help window
	if ($FORM{'size'} eq 'small') {
		$text = &getTemplate("$CONFIG{'Language'}.help");
		$text ||= &getTemplate("english.help");
		s/<!--begin-->/$text/;
	}

# Handle full-size help
	else {
		($htmlhead, $htmlfoot) = split(/<!--begin-->/);

		&btnStart;

		&btnAdd('do=logout', 	'Logout');
		&btnBreak;

		&btnAdd("do=inbox", 	'Inbox');
		&btnAdd('do=compose', 	'Compose');
		&btnAdd('do=showdraft',	'ShowDraft') if $CONFIG{'Draft'};
		&btnBreak;

		&btnAdd('do=options', 	'Options');
		&btnAdd('do=abook',		'Addresses');

		&btnEnd;

		$_ = "$htmlhead\n" .
		 	($CONFIG{'ButtonRowLocation'} =~ /(both|top)/ and "$buttonrow\n<P>\n") .

			"<TABLE WIDTH=\"$CONFIG{TableWidth}\">\n" .
			&getTemplate("$CONFIG{'Language'}.help") .
			"</TABLE>\n" .

			($CONFIG{'ButtonRowLocation'} =~ /(both|bottom)/ and "$buttonrow\n<P>\n") .
			"$htmlfoot\n";
	}

# Print headers & da page
	&httpHeaders;
	print "Content-Type: text/html$crlf$crlf$_\n";

# Save log entry
	saveString("$CONFIG{'LogPath'}main.log", "help,1,$CONFIG{'Language'}\n");
	exit;
}


# Show the list of editable keys --------------------------------------------

sub keyList {

	&httpHeaders;

	print "Content-Type: text/html${crlf}${crlf}", &getTemplate('keylist.html');
	exit;
}


# Show one key in key editor ------------------------------------------------

sub showKey {

	&httpHeaders;

	print "Content-Type: text/html${crlf}${crlf}<BIG>$FORM{'key'}</BIG><P>\n";

	if ($FORM{'type'} eq 'show') {
		print &webify($CONFIG{$FORM{'key'}});
		return;
	}

	print "<FORM ACTION=\"$CONFIG{'ScriptName'}\" METHOD=\"post\">\n",
		&hiddenFields('showkey'),
		"<INPUT TYPE=\"hidden\" NAME=\"key\" VALUE=\"$FORM{'key'}\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"type\" VALUE=\"$FORM{'type'}\">\n";

	if ($FORM{'type'} eq 'edit') {
		print "<INPUT TYPE=\"text\" NAME=\"config$FORM{'key'}\" VALUE=\"", 
			&webify($CONFIG{$FORM{'key'}}), "\" SIZE=40>\n";
	}
	elsif ($FORM{'type'} eq 'multi') {
		print "<TEXTAREA NAME=\"config$FORM{'key'}\" ROWS=10 COLS=40>",
			&webify($CONFIG{$FORM{'key'}}), "</TEXTAREA>\n";
	}
	elsif ($FORM{'type'} eq 'boolean') {
		$checked = $CONFIG{$FORM{'key'}} ? ' CHECKED' : '';
		print "<INPUT TYPE=\"radio\" NAME=\"config$FORM{'key'}\" VALUE=\"1\"$checked> True<BR>\n";

		$checked = $checked ? '' : ' CHECKED';
		print "<INPUT TYPE=\"radio\" NAME=\"config$FORM{'key'}\" VALUE=\"\"$checked> False\n";
	}
	else {
		for (split(/\|/, $FORM{'type'})) {
			$checked = ($CONFIG{$FORM{'key'}} eq $_) ? ' CHECKED' : '';
			print "<INPUT TYPE=\"radio\" NAME=\"config$FORM{'key'}\" VALUE=\"$_\"$checked> $_<BR>\n";
		}
	}

	print "<P>";

	if ($CONFIG{'DefaultSave'} !~ /\b$FORM{'key'}\b/) {
		$_ = $CONFIG{'AdditionalSave'};
		s/$FORM{'key'},//;
		$checked = $CONFIG{'AdditionalSave'} =~ /\b$FORM{'key'}\b/ ? '' : ' CHECKED';

		print "<INPUT TYPE=\"radio\" NAME=\"configAdditionalSave\" VALUE=\"$_\"$checked> ",
			"This session only (reset to default after logoff)<BR>\n";

		$_ .= "$FORM{'key'},";
		$checked = $checked ? '' : ' CHECKED';

		print "<INPUT TYPE=\"radio\" NAME=\"configAdditionalSave\" VALUE=\"$_\"$checked> ",
			"Permanent change\n";
	}

	print "<P><INPUT TYPE=\"submit\" VALUE=\"Change value\"></FORM>\n";
}


# Click an advertisement ----------------------------------------------------

sub adClick {

	&loadAdConfig("$CONFIG{'AdvertisementPath'}$FORM{'ad'}/ad.cfg") or do { &inbox; return; };

	$AD{'Clicks'}++;

	&saveAdConfig("$CONFIG{'AdvertisementPath'}$FORM{'ad'}/ad.cfg");
	&saveString("$CONFIG{'LogPath'}main.log", "click,1,$FORM{'ad'}," . time . "\n");

	$CONFIG{'AdClicks'}++;

	&redirect($AD{'Destination'});
}


# AddressBook ---------------------------------------------------------------

sub addressbook {

	&httpHeaders;

# Get template
	&advertisement;
	&helpButton('AddressBook');

	$_ = &getTemplate('addresses.html');
	($htmlhead, $htmlfoot) = split(/<!--begin-->/);

# Generate buttons
	&btnStart;

	&btnAdd('do=logout', 	'Logout');
#	&btnAdd('do=inbox', 	'Inbox');
	&btnBreak;

	&btnAdd($FORM{'msg'} ? "do=read\&msg=$FORM{'msg'}" : 'do=inbox', 'Cancel');
	&btnAdd('SUBMIT', 		'Save');
	&btnBreak;

#	&btnAdd('do=search', 	'Search');

	&btnEnd;

# Print addressbook
	print "Content-Type: text/html$crlf$crlf$htmlhead\n",
	 	($CONFIG{'ButtonRowLocation'} =~ /(both|top)/ and "$buttonrow\n<P>\n"),

		"<TEXTAREA COLS=70 ROWS=16 NAME=\"configAddressBook\">",
		&webify($CONFIG{'AddressBook'}), "</TEXTAREA>",

		"<P>\n", &hiddenFields($FORM{'msg'} ? 'read' : 'inbox'),
		"<INPUT TYPE=\"hidden\" NAME=\"msg\" VALUE=\"$FORM{'msg'}\">\n";

	&btnFixBottom;

	print '', ($CONFIG{'ButtonRowLocation'} =~ /(both|bottom)/ and "$buttonrow\n<P>\n"), 
		"$htmlfoot\n";
}


# Add one address to the addressbook ----------------------------------------

sub saveAddress {

        my ($name, $email) = @_;
        my ($temp);

		$name ||= $FORM{'name'};
		$email ||= $FORM{'email'};

# Skip saving if the address is already there
        $temp = $email;
        $temp =~ s/\W/\\$&/g;

        if ($CONFIG{'AddressBook'} !~ /$temp/i) {
	        $temp = $name;
    	    $temp =~ s/\W/\\$&/g;

# Is the name already there?
        	if ($CONFIG{'AddressBook'} =~ /^\s*$temp\s*:/im) {

# Yes -> append to the old entry
		        $CONFIG{'AddressBook'} =~ s/^\s*$temp\s*:.*/$&, $email/im;
			}

# No -> Create a new entry
			else {
				if ($CONFIG{'AddressBook'}) {
	        		$CONFIG{'AddressBook'} =~ /\n$/ or $CONFIG{'AddressBook'} .= "\n";
				}
		        $CONFIG{'AddressBook'} .= "$name: $email\n";
			}
		}

		if ($FORM{'do'} =~ /saveaddress/) {
			if ($CONFIG{'AddressBookAfterSave'}) { &addressbook; }
			else { &read; }
		}
}


# Show options --------------------------------------------------------------

sub options {

	my ($noct) = shift;

# Print headers
	&httpHeaders;

# Make an educated guess
	if (!$CONFIG{'RealEmail'}) {

		$_ = $CONFIG{'Server'};
		s/^(pop|mail)\.(\w+\.\w+)/$2/;

		$CONFIG{'RealEmail'} = "$CONFIG{'Login'}\@$_";
	}

# Get da template
	&advertisement;
	&helpButton('Options');

	$page = &getTemplate('options.html');

# Generate buttons
	&btnStart;

	&btnAdd('do=logout', 	'Logout');
	&btnBreak;

	&btnAdd('do=inbox', 	'Cancel') if $CONFIG{'RealName'};
	&btnAdd('SUBMIT', 		'Save');
	&btnBreak;

	&btnAdd('javascript:keyEditor();', 'KeyEditor') if $CONFIG{'JavaScript'} > 1;
	&btnEnd;

# Fix & print page
	$page =~ s#<!--top-->#$CONFIG{'ButtonRowLocation'} =~ /(both|top)/ ? $buttonrow : ''#e;

	&btnFixBottom;
	$page =~ s#<!--bottom-->#$CONFIG{'ButtonRowLocation'} =~ /(both|bottom)/ ? $buttonrow : ''#e;
	
	$page =~ s/<!--quote-->/$CONFIG{'NoQuotedReply'} ? '' : ' CHECKED'/e;
	$page =~ s/<!--autosave-->/$CONFIG{'NoAutoSave'} ? '' : ' CHECKED'/e;

	for ('from', 'replyto', 'cc', 'bcc', 'priority') {
		$page =~ s#<!--$_-->#$CONFIG{'HideInCompose'} !~ /\b$_\b/ ? ' CHECKED' : ''#e;
	}

	$page =~ s/<!--signature-->/&webify($CONFIG{'Signature'})/e;
	$page =~ s/<!--hidden-->/&hiddenFields('saveopt')/e;

	print "Content-Type: text/html$crlf$crlf" unless $noct;
	print $page;
}


# Save options --------------------------------------------------------------

sub saveOptions {

	$CONFIG{'NoQuotedReply'} = $FORM{'quote'} ? 0 : 1;
	$CONFIG{'NoAutoSave'} = $FORM{'autosave'} ? 0 : 1;

	$CONFIG{'RealName'} =~ tr/\"<>//d;
	$CONFIG{'RealEmail'} =~ tr/\"<>//d;

	$CONFIG{'HideInCompose'} = 'newsgroups, ';

	for ('from', 'replyto', 'cc', 'bcc', 'priority') {
		$CONFIG{'HideInCompose'} .= "$_, " unless $FORM{$_};
	}

	&loadConfig("$CONFIG{'Language'}.cfg");

	&inbox;
}


# Download an attachment ----------------------------------------------------

sub download {

# Print headers (IE won't accept normal expiring headers..... duh!)
	print "$ENV{'SERVER_PROTOCOL'} 200 OK${crlf}" if $CONFIG{'FullHTTPHeaders'};

# Handle Content-ID -downloads
	if ($FORM{'cid'}) {
		$cid = $FORM{'cid'};
		$cid =~ s/\W/\\$&/g;
		$atch = 1;

		while (open(FILE, "<$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch")) {
			binmode FILE if ($WinNT);

			$header = '';
			while (<FILE>) {
				/^\s*$/ and last;
				$header .= "$_\n";
			}

			$header =~ /Content-ID:.*$cid/i and last;
			$atch++;
		}

		$FORM{'msg'} = $atch;
	}

# Open files
	open(FILE, "<$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$FORM{'msg'}");
	binmode FILE if ($WinNT);

	$filename = &getRandomFilename;
	open(ATCHFILE, ">$CONFIG{'TempPath'}$filename");
	binmode ATCHFILE if ($WinNT);

# Get header
	$header = '';
	while (<FILE>) {
		/^\s*$/ and last;
		$header .= "$_\n";
	}


# Decode Macintosh BinHex (first pass)
	if ($header =~ /^Content-Type\:.*application\/mac-binhex40/im) {

		$hqx = &getRandomFilename;
		open(HQXFILE, ">$CONFIG{'TempPath'}$hqx");
		binmode HQXFILE if ($WinNT);

		$data = '';

		while (<FILE>) { /^\(This file must be converted with BinHex 4\.0\)/ and last; };
		while (<FILE>) {

			tr/:\x0d\x0a\s//d;
			tr|!"#$%&'()*+,\-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr|A-Za-z0-9+/|;		# Convert to BASE64

			$data .= $_;

			if ((length($data) % 4) == 0) {
				print HQXFILE &base64Decode($data);
				$data = '';

				next;
			}

			while (length($data) > 60) {
				print HQXFILE &base64Decode(substr($data, 0, 60));
				$data = substr($data, 60);
			}
		}

		close(HQXFILE);
		open(FILE, "<$CONFIG{'TempPath'}$hqx");
		binmode FILE if ($WinNT);
	}

# Print correct Content-Type
	$header =~ /X-Content-Name: \"(.*?)\"/ and
		print "Content-Disposition: attachment; filename=\"$1\"$crlf"; 

	if ($header =~ /^Content-Type\:\s*(.*)/im and !$FORM{'type'}) {
		print "Content-Type: $1$crlf";
	}
	elsif ($FORM{'type'} =~ /text/) {
		print "Content-Type: text/plain$crlf";
	}
	else {
		print "Content-Type: application/x-download$crlf";
	}

# Decode BASE64
	if ($header =~ /^Content-Transfer-Encoding\:\s*base64/im) {

		while (<FILE>) {
			print ATCHFILE &base64Decode($_);
		}
	}

# Decode QP
	elsif ($header =~ /^Content-Transfer-Encoding\:\s*quoted-printable/im) {

		while (<FILE>) {
			s/=\s*\n//g;
			s/=([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
			print ATCHFILE $_;
		}
	}

# Decode uuencode
	elsif ($header =~ /^Content-Transfer-Encoding\:.*uuencode/im) {

		while (<FILE>) { /^begin/ and last; };
		while (<FILE>) {
			
			/^end/ and last;
			print ATCHFILE unpack("u", $_);
		}
	}

# Decode Macintosh BinHex (second pass)
	elsif ($header =~ /^Content-Type\:.*application\/mac-binhex40/im) {

		$_ = ord(getc(FILE));				# Length of filename
		seek FILE, $_ + 11, 1;				# Skip filename & some header stuff

		$len = 0;							# Get the lenght of the data fork
		for (1 .. 4) { $len = $len * 256 + ord(getc(FILE)); }

		seek FILE, 6, 1;					# Skip header stuff
		$lastbyte = getc(FILE);

		for (1 .. $len) {					# Read data fork
			$byte = getc(FILE);

			if (ord($byte) == 144) {		# Parse RLE
				$byte = getc(ATCH);			# Get length

				if ($byte != 0) {
					$lastbyte = $lastbyte x $byte;
					$byte = getc(FILE);
				}
				else {
					$lastbyte .= chr(144);
					getc(FILE);
					$byte = '';
				}
			}

			print ATCHFILE $lastbyte;
			$lastbyte = $byte;
		}

		unlink("$CONFIG{'TempPath'}$hqx");
	}

# Handle non-decoded attachments
	else {
		while (<FILE>) { print ATCHFILE $_; }
	}

	close(ATCHFILE);
	close(FILE);

# Print attachment
	open(FILE, "<$CONFIG{'TempPath'}$filename");
	binmode FILE if ($WinNT);

	if ($FORM{'type'} =~ /text/) {
		print $crlf;

		while (<FILE>) {

			tr/\x00-\x09\x0b\x0c\x0e-\x1f\x7f-\x9f\xff//d;
			s/.{80,}/&wordWrap($&, 80)/ge;

			print;
		}
	}
	else {
		print "Content-Length: ", -s "$CONFIG{'TempPath'}$filename", "$crlf$crlf";
		while (<FILE>) { print; }
	}

	close(FILE);
	unlink("$CONFIG{'TempPath'}$filename");

	exit;
}


# New attachment ------------------------------------------------------------

sub attach {

	&httpHeaders;
	$_ = &getTemplate('attach.html');

# Generate buttons
	&btnStart;

	&btnAdd('javascript:document.mainform.submit();', 'Send');
	&btnAdd('javascript:window.close();', 'Cancel');

	&btnEnd;

	$buttonrow .= &hiddenFields('upload');
	s/<!--begin-->/$buttonrow/;

# Print html
	print "Content-Type: text/html$crlf$crlf$_";
}


# Check spelling ------------------------------------------------------------

sub checkSpelling {

	&httpHeaders;

# Get & print HTML-template
	print "Content-Type: text/html$crlf$crlf", &getTemplate('spellcheck.html');
	&flush;

# Get the text to check
	$text = $FORM{'body'};
	$errorcount = 0;

# Load the main wordlist
	open(FILE, "<$CONFIG{'ScriptPath'}$CONFIG{'WordListFile'}");
	while (<FILE>) {

		tr/\x0d\x0a//d;
		$WORDS{$_} = 1;

		$subtable = substr($_, 0, 2);
		$subtable =~ tr/A-Z/a-z/;
		$$subtable .= "$_\n";
	}
	close(FILE);

# Add custom words to da list
	while ($CONFIG{'CustomWords'} =~ /.*/g) {
		$_ = $&;

		tr/\x0d\x0a//d;
		$WORDS{$_} = 1;

		$subtable = substr($_, 0, 2);
		$subtable =~ tr/A-Z/a-z/;
		$$subtable .= "$_\n";
	}

# Remove known non-words
	$text =~ s!(http:|ftp:)//[\w.\,:/=\&?\@#\-~\%]*[\w/]!' ' x length($&)!gie;
	$text =~ s!\w*www\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!' ' x length($&)!gie;
	$text =~ s!\w*ftp\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!' ' x length($&)!gie;
	$text =~ s![\w.\-]+\@[\w.\-]+\.\w+!' ' x length($&)!ge;

	$text =~ s/<.*?>/' ' x length($&)/ges;
	$text =~ s/&(lt|gt|quot);/' ' x length($&)/ges;

	$text =~ s/(\w)(n\'t|\'ll|\'ve\b)/"$1" . ' ' x length($2)/gie;

# Loop through each word in da text
	while ($text =~ /\b(.+?)\b/g) {

		$word = $1;
		$original = $1;
		$pos = pos $text;

		next if ($word =~ /[a-z][A-Z]/);		# mIxEd-mAtCh?
		next if (length($word) < 2);			# Too short?

		next if ($WORDS{$word});				# Already correctly spelled?

		$word =~ tr/A-Z/a-z/;					# Convert to lowecase

		next if ($word =~ /[^a-z]/);			# Illegal chars?
		next if ($WORDS{$word});				# Already correctly spelled?

		if ($ALT{$word}) {						# Already handled?
			&fixWord($pos, $original, $ALT{$word});
			next;
		}

		$alt = '';

# Find incorrect capitalization
		$subtable = substr($word, 0, 2);
		while ($$subtable =~ /^$word$/gim) { $alt .= "$&|"; }

# Skip too short words
		if (length($word) < 3) {
			&fixWord($pos, $original, ($alt or '|'));
			$ALT{$original} = $alt;

			next;
		}

# Check for a missing space
		for ($start = 2; $start <= length($word) - 2; $start++) {

			$_ = $word;
			substr($_, $start, 0) = ' ';
			($word1, $word2) = split(/ /);

			$subtable1 = substr($word1, 0, 2);
			$subtable2 = substr($word2, 0, 2);

			if (($$subtable1 =~ /^$word1$/im and $_ = $&) and
				$$subtable2 =~ /^$word2$/im) {

				$alt .= "$_ $&|$_-$&|";
			}
		}

# Find alternatives
		$dotlen = (length($word) < 5) ? 1 : 2;
		for ($start = 2; $start <= length($word) - $dotlen; $start++) {

			$temp = $word;
			substr($temp, $start, $dotlen) = 
				($dotlen == 1) ? '.{1,2}' : '.{1,3}';

			$subtable = substr($word, 0, 2);
			while ($$subtable =~ /^$temp$/gim) { $alt .= "$&|"; }
		}

# Remove duplicate alternatives
		@alt = split(/\|/, $alt);
		$alt = '|';
		$rightAfterAll = 0;

		foreach (@alt) {
			if ($original !~ /[a-z]/) { tr/a-z/A-Z/; }
			elsif	($original =~ /^[A-Z]/) {

				$temp = substr($_, 0, 1);
				$temp =~ tr/a-z/A-Z/;
				substr($_, 0, 1) = $temp;
			}

			$rightAfterAll = 1 if (/$original/);

			next if $alt =~ /\|$_\|/;
			$alt .= "$_|";
		}
		next if ($rightAfterAll);

# Store word & alternatives
		$ALT{$original} = $alt;
		&fixWord($pos, $original, $alt);
	}

	&fixWord(-1, '', '');
	print "\n</SCRIPT>\n";
}


# Print JavaScript for da misspelled word -----------------------------------

sub fixWord {

	my ($pos, $word, $alt) = @_;

	$errorcount++;
	print "pos$errorcount = $pos; ",
		"word$errorcount = '$word'; ",
		"alt$errorcount = '$alt'; ",
		"errcount++;\n";
}


# Add one word to users custom dictionary -----------------------------------

sub addWord {

	$CONFIG{'CustomWords'} =~ /\n$/ or $CONFIG{'CustomWords'} .= "\n";
	$CONFIG{'CustomWords'} .= $FORM{'word'};

	&httpHeaders;
	print "Content-Type: text/plain${crlf}${crlf}Just say Koff!\n";
}


# Handle multipart/form-data stream from browser ----------------------------

sub getBinaryUpload {

# Get the boundary
	eval $timeoutOn;

	while (<STDIN>) {		# A fix for MSIE4 - remove blank lines before boundary
		if (/^--/) {
			$boundary = $_;
			last;
		}
	}

	$boundary =~ tr/\x0d\x0a//d;
	$boundary =~ s/\W/\\$&/g;

# Loop through all entries
	for (;;) {

# Get the header
		$header = "";

		for (;;) {
			eval $timeoutOn;
			$_ = <STDIN> or last;
			/^\s*$/ and last;

			$header .= $_;
		}

		$header =~ / name=\"(.*?)\"/;
		$name = $1;

# Handle binary upload
		if ($header =~ /filename=\"(.*?)\"/) {
			$filename = $1;

			if ($header =~ /Content-Type:\s*(.*)/) { $ctype = $1; }
			else { $ctype = "application/octet-stream"; };

			$tempfile = &getRandomFilename;
			open(FILE, ">$CONFIG{'TempPath'}$tempfile");
			binmode FILE if $WinNT;

			for (;;) {
				$_ = <STDIN> or last;
				/$boundary/ and last;

				print FILE $_;
			}

			close(FILE);

			/$boundary--/ and last;
		}

# Handle normal fields
		else {
			$value = "";

			for (;;) {
				eval $timeoutOn;
				$_ = <STDIN> or last;
				/$boundary/ and last;

				$value .= $_;
			}

			chop $value; chop $value;
			$FORM{$name} = $value;

			/$boundary--/ and last;
		}
	}

	eval $timeoutOff;

# Encode uploaded binary file (if any)
	if ($tempfile) {
		$size = -s "$CONFIG{'TempPath'}$tempfile";
		$size -= 2;
	}
	else { $size = 0; };

	if ($size > 0) {
		$out = 1;
		while (-e "$CONFIG{'TempPath'}$FORM{'u'}\.out\.$out") { $out++; }

		open(FILE, "<$CONFIG{'TempPath'}$tempfile");
		binmode FILE if $WinNT;

		open(ATCH, ">$CONFIG{'TempPath'}$FORM{'u'}\.out\.$out");
		binmode ATCH if $WinNT;

		$filename =~ s/^.*[\\\/:]//;
		$filename =~ tr/A-Za-z0-9_.\-//cd;
		$ctype =~ tr/\x0d\x0a//d;

		$FORM{'attachment'} = $filename;

		print ATCH "Content-Type: $ctype; name=\"$filename\"${crlf}",
			"Content-Disposition: inline; filename=\"$filename\"${crlf}",
			"Content-Length: $size${crlf}";

		if ($FORM{'uuencode'}) {
			print ATCH "Content-Transfer-Encoding: x-uuencode$crlf$crlf",
				"begin 644 $filename\n";
		}
		else {
			print ATCH "Content-Transfer-Encoding: base64$crlf$crlf";
		}

		for (;;) {
			if ($size > 45) {
				read(FILE, $_, 45);
				$size -= 45;
			}
			else {
				read(FILE, $_, $size);
				$size = 0;
			}

			$mod = length($_) % 3;

			$_ = pack("u", $_);			# Convert binary string to uuencode

			if (!$FORM{'uuencode'}) {
				s/^.//;					# Remove lenght
				tr#`!-_#A-Za-z0-9+/#;	# Convert uuencode -> base64

				if ($mod == 1) {		# Pad last string with ='s
					s/..\n$/==\n/;
				}
				elsif ($mod == 2) {
					s/.\n$/=\n/;
				}
			}

			print ATCH "$_";

			last if $size == 0;
		}

		if ($FORM{'uuencode'}) { print ATCH "`\nend\n"; }

		close(ATCH);
		close(FILE);
	}

	unlink("$CONFIG{'TempPath'}$tempfile") if $tempfile;

# Handle action=upload
	if ($FORM{'do'} =~ /upload/) {

		print "Content-Type: text/html$crlf$crlf",
			"<SCRIPT>\nopener.afterUpload('$filename');\n</SCRIPT>\n";

		exit;
	}
}


1;
