/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include "geom_bonus.h"

// 42 Verticies
// 21 Texture Coordinates
// 98 Normals
// 80 Triangles

static char star_face_indicies[80][9] = {
  {0, 8, 1, 0, 0, 0, 0, 1, 2}, {1, 9, 2, 1, 1, 1, 2, 3, 4}, {2, 27, 3, 2, 2,
                                                             2, 5, 6, 7},
  {3, 28, 4, 3, 3, 3, 4, 3, 2}, {4, 5, 0, 4, 4, 4, 2, 1, 0}, {5, 29, 6, 5, 5,
                                                              5, 1, 8, 9},
  {6, 12, 7, 6, 6, 6, 2, 0, 1}, {7, 11, 8, 7, 7, 7, 9, 8, 1}, {10, 15, 9, 8,
                                                               8, 8, 0, 2, 1},
  {11, 14, 10, 9, 9, 9, 1, 2, 0}, {12, 18, 13, 10, 10, 10, 0, 2, 1}, {13, 17,
                                                                      14, 11,
                                                                      11, 11,
                                                                      1, 8,
                                                                      9},
  {16, 21, 15, 12, 12, 12, 4, 3, 2}, {17, 20, 16, 13, 13, 13, 5, 6, 7}, {18,
                                                                         24,
                                                                         19,
                                                                         14,
                                                                         14,
                                                                         14,
                                                                         10,
                                                                         11,
                                                                         5},
  {19, 23, 20, 15, 15, 15, 5, 7, 6}, {22, 27, 21, 16, 16, 16, 7, 6, 5}, {23,
                                                                         26,
                                                                         22,
                                                                         17,
                                                                         17,
                                                                         17,
                                                                         7,
                                                                         12,
                                                                         13},
  {24, 29, 25, 18, 18, 18, 7, 5, 6}, {25, 28, 26, 19, 19, 19, 6, 5, 7}, {30,
                                                                         1, 2,
                                                                         20,
                                                                         21,
                                                                         21,
                                                                         14,
                                                                         9,
                                                                         8},
  {30, 2, 3, 20, 22, 22, 15, 16, 17}, {30, 3, 4, 20, 23, 23, 14, 11, 10},
  {30, 4, 0, 20, 24, 24, 14, 10, 18}, {30, 0, 1, 20, 25, 25, 14, 18, 9},
  {31, 5, 6, 26, 27, 27, 14, 10, 11}, {31, 6, 7, 26, 28, 28, 15, 17, 16},
  {31, 7, 8, 26, 29, 29, 14, 8, 9}, {31, 8, 0, 26, 30, 30, 14, 9, 18}, {31, 0,
                                                                        5, 26,
                                                                        31,
                                                                        31,
                                                                        14,
                                                                        18,
                                                                        10},
  {32, 8, 11, 32, 33, 33, 14, 8, 9}, {32, 11, 10, 32, 34, 34, 14, 9, 18},
  {32, 10, 9, 32, 35, 35, 14, 18, 10}, {32, 9, 1, 32, 36, 36, 14, 10, 11},
  {32, 1, 8, 32, 37, 37, 15, 17, 16}, {33, 7, 12, 38, 39, 39, 14, 9, 18},
  {33, 12, 13, 38, 40, 40, 14, 18, 10}, {33, 13, 14, 38, 41, 41, 14, 10, 11},
  {33, 14, 11, 38, 42, 43, 15, 17, 16}, {33, 11, 7, 38, 43, 44, 14, 8, 9},
  {34, 14, 17, 45, 46, 47, 14, 9, 8}, {34, 17, 16, 45, 47, 48, 15, 16, 17},
  {34, 16, 15, 45, 49, 49, 14, 11, 10}, {34, 15, 10, 45, 50, 50, 14, 10, 18},
  {34, 10, 14, 45, 51, 51, 14, 18, 9}, {35, 13, 18, 52, 53, 53, 19, 3, 12},
  {35, 18, 19, 52, 54, 54, 19, 12, 13}, {35, 19, 20, 52, 55, 55, 19, 13, 20},
  {35, 20, 17, 52, 56, 56, 19, 20, 4}, {35, 17, 13, 52, 57, 57, 19, 4, 3},
  {36, 20, 23, 58, 59, 59, 19, 20, 13}, {36, 23, 22, 58, 60, 60, 19, 13, 12},
  {36, 22, 21, 58, 61, 62, 19, 12, 3}, {36, 21, 16, 58, 62, 63, 19, 3, 4},
  {36, 16, 20, 58, 63, 64, 19, 4, 20}, {37, 19, 24, 65, 66, 66, 19, 3, 4},
  {37, 24, 25, 65, 67, 67, 19, 4, 20}, {37, 25, 26, 65, 68, 68, 19, 20, 13},
  {37, 26, 23, 65, 69, 69, 19, 13, 12}, {37, 23, 19, 65, 70, 70, 19, 12, 3},
  {38, 26, 28, 71, 72, 73, 19, 12, 3}, {38, 28, 3, 71, 73, 74, 19, 3, 4},
  {38, 3, 27, 71, 75, 75, 19, 4, 20}, {38, 27, 22, 71, 76, 76, 19, 20, 13},
  {38, 22, 26, 71, 77, 72, 19, 13, 12}, {39, 25, 29, 78, 79, 79, 19, 20, 4},
  {39, 29, 5, 78, 80, 80, 19, 4, 3}, {39, 5, 4, 78, 81, 81, 19, 3, 12}, {39,
                                                                         4,
                                                                         28,
                                                                         78,
                                                                         82,
                                                                         82,
                                                                         19,
                                                                         12,
                                                                         13},
  {39, 28, 25, 78, 83, 83, 19, 13, 20}, {40, 29, 24, 84, 85, 86, 15, 16, 17},
  {40, 24, 18, 84, 86, 87, 14, 11, 10}, {40, 18, 12, 84, 88, 88, 14, 10, 18},
  {40, 12, 6, 84, 89, 90, 14, 18, 9}, {40, 6, 29, 84, 90, 85, 14, 9, 8},
  {41, 2, 9, 91, 92, 93, 19, 4, 3}, {41, 9, 15, 91, 93, 94, 19, 3, 12}, {41,
                                                                         15,
                                                                         21,
                                                                         91,
                                                                         95,
                                                                         95,
                                                                         19,
                                                                         12,
                                                                         13},
  {41, 21, 27, 91, 96, 96, 19, 13, 20}, {41, 27, 2, 91, 97, 92, 19, 20, 4}
};

/*static GLfloat star_vertices [42][3] = {
{-1.2547e-08f,0.0f,0.2f},{0.1f,0.161803f,-0.0618034f},{-0.161803f,0.0618034f,0.1f},
{0.161803f,0.0618034f,0.1f},{-0.1f,0.161803f,-0.0618034f},{-0.1f,-0.161803f,-0.0618034f},
{0.161803f,-0.0618034f,0.1f},{-0.161803f,-0.0618034f,0.1f},{0.1f,-0.161803f,-0.0618034f},
{-0.0618034f,-0.1f,-0.161803f},{0.2f,0.0f,9.22162e-12f},{-0.0618034f,0.1f,-0.161803f},
{-1.2547e-08f,0.2f,2.62522e-11f},{-0.161803f,-0.0618034f,-0.1f},{-0.0618034f,0.1f,0.161803f},
{-0.0618034f,-0.1f,0.161803f},{0.1f,0.161803f,0.0618034f},{0.1f,-0.161803f,0.0618034f},
{0.161803f,-0.0618034f,-0.1f},{-0.1f,-0.161803f,0.0618034f},{-1.2547e-08f,0.0f,-0.2f},
{-0.161803f,0.0618034f,-0.1f},{0.161803f,0.0618034f,-0.1f},{-0.1f,0.161803f,0.0618034f},
{0.0618034f,0.1f,0.161803f},{-0.2f,0.0f,2.32315e-11f},{0.0618034f,-0.1f,0.161803f},
{-1.2547e-08f,-0.2f,-7.87591e-11f},{0.0618034f,-0.1f,-0.161803f},{0.0618034f,0.1f,-0.161803f},
{-1.2547e-08f,0.0894427f,0.0552786f},{-1.2547e-08f,-0.0894427f,0.0552786f},{0.0552786f,0.0f,-0.0894427f},
{-0.0894427f,0.0552786f,-8.408e-12f},{0.0552786f,0.0f,0.0894427f},{-1.2547e-08f,-0.0894427f,-0.0552786f},
{-1.2547e-08f,0.0894427f,-0.0552786f},{-0.0552786f,0.0f,0.0894427f},{0.0894427f,-0.0552786f,-2.20859e-11f},
{-0.0552786f,0.0f,-0.0894427f},{0.0894427f,0.0552786f,3.38179e-11f},{-0.0894427f,-0.0552786f,-2.79414e-11f}
};*/

static GLfloat star_vertices[42][3] = {
  {-1.72521e-08f, 0.0f, 0.275f}, {0.1375f, 0.22248f, -0.0849797f}, {-0.22248f,
                                                                    0.0849797f,
                                                                    0.1375f},
  {0.22248f, 0.0849797f, 0.1375f}, {-0.1375f, 0.22248f, -0.0849797f},
    {-0.1375f, -0.22248f, -0.0849797f},
  {0.22248f, -0.0849797f, 0.1375f}, {-0.22248f, -0.0849797f, 0.1375f},
    {0.1375f, -0.22248f, -0.0849797f},
  {-0.0849797f, -0.1375f, -0.22248f}, {0.275f, 0.0f, 1.26797e-11f},
    {-0.0849797f, 0.1375f, -0.22248f},
  {-1.72521e-08f, 0.275f, 3.60968e-11f}, {-0.22248f, -0.0849797f, -0.1375f},
    {-0.0849797f, 0.1375f, 0.22248f},
  {-0.0849797f, -0.1375f, 0.22248f}, {0.1375f, 0.22248f, 0.0849797f},
    {0.1375f, -0.22248f, 0.0849797f},
  {0.22248f, -0.0849797f, -0.1375f}, {-0.1375f, -0.22248f, 0.0849797f},
    {-1.72521e-08f, 0.0f, -0.275f},
  {-0.22248f, 0.0849797f, -0.1375f}, {0.22248f, 0.0849797f, -0.1375f},
    {-0.1375f, 0.22248f, 0.0849797f},
  {0.0849797f, 0.1375f, 0.22248f}, {-0.275f, 0.0f, 3.19434e-11f}, {0.0849797f,
                                                                   -0.1375f,
                                                                   0.22248f},
  {-1.72521e-08f, -0.275f, -1.08294e-10f}, {0.0849797f, -0.1375f, -0.22248f},
    {0.0849797f, 0.1375f, -0.22248f},
  {-1.72521e-08f, 0.122984f, 0.0760081f}, {-1.72521e-08f, -0.122984f,
                                           0.0760081f}, {0.0760081f, 0.0f,
                                                         -0.122984f},
  {-0.122984f, 0.0760081f, -1.1561e-11f}, {0.0760081f, 0.0f, 0.122984f},
    {-1.72521e-08f, -0.122984f, -0.0760081f},
  {-1.72521e-08f, 0.122984f, -0.0760081f}, {-0.0760081f, 0.0f, 0.122984f},
    {0.122984f, -0.0760081f, -3.03681e-11f},
  {-0.0760081f, 0.0f, -0.122984f}, {0.122984f, 0.0760081f, 4.64996e-11f},
    {-0.122984f, -0.0760081f, -3.84195e-11f}
};

static GLfloat star_normals[98][3] = {
  {0.934172f, 0.0f, 0.356822f}, {-0.57735f, 0.57735f, -0.57735f}, {0.0f,
                                                                   -0.356822f,
                                                                   0.934172f},
  {0.57735f, 0.57735f, -0.57735f}, {-0.934172f, 0.0f, 0.356822f}, {0.57735f,
                                                                   -0.57735f,
                                                                   -0.57735f},
  {0.0f, 0.356822f, 0.934172f}, {-0.57735f, -0.57735f, -0.57735f}, {0.356822f,
                                                                    -0.934172f,
                                                                    0.0f},
  {0.356822f, 0.934172f, 0.0f}, {0.0f, 0.356822f, -0.934172f}, {-0.57735f,
                                                                -0.57735f,
                                                                0.57735f},
  {-0.57735f, 0.57735f, 0.57735f}, {0.934172f, 0.0f, -0.356822f}, {0.57735f,
                                                                   -0.57735f,
                                                                   0.57735f},
  {-0.934172f, 0.0f, -0.356822f}, {0.0f, -0.356822f, -0.934172f}, {0.57735f,
                                                                   0.57735f,
                                                                   0.57735f},
  {-0.356822f, 0.934172f, 0.0f}, {-0.356822f, -0.934172f, 0.0f}, {0.0f,
                                                                  0.850651f,
                                                                  0.525731f},
  {2.26478e-08f, 0.850651f, 0.525731f}, {0.0f, 0.850651f, 0.525731f},
    {-2.26478e-08f, 0.850651f, 0.525731f},
  {6.77345e-08f, 0.850651f, 0.525731f}, {-6.77345e-08f, 0.850651f, 0.525731f},
    {1.42109e-15f, -0.850651f, 0.525731f},
  {-4.93306e-08f, -0.850651f, 0.525731f}, {0.0f, -0.850651f, 0.525731f},
    {4.93306e-08f, -0.850651f, 0.525731f},
  {-5.75426e-08f, -0.850651f, 0.525731f}, {5.75426e-08f, -0.850651f,
                                           0.525731f}, {0.525731f,
                                                        7.10543e-16f,
                                                        -0.850651f},
  {0.525731f, 4.93306e-08f, -0.850651f}, {0.525731f, -5.74791e-08f,
                                          -0.850651f}, {0.525731f,
                                                        5.74791e-08f,
                                                        -0.850651f},
  {0.525731f, -4.93306e-08f, -0.850651f}, {0.525731f, 0.0f, -0.850651f},
    {-0.850651f, 0.525731f, 0.0f},
  {-0.850651f, 0.525731f, 3.26978e-08f}, {-0.850651f, 0.525731f,
                                          -3.26978e-08f}, {-0.850651f,
                                                           0.525731f,
                                                           6.44096e-09f},
  {-0.850651f, 0.525731f, 0.0f}, {-0.850651f, 0.525731f, -3.22048e-09f},
    {-0.850651f, 0.525731f, -6.44096e-09f},
  {0.525731f, 7.10543e-16f, 0.850651f}, {0.525731f, 4.93306e-08f, 0.850651f},
    {0.525731f, 2.46653e-08f, 0.850651f},
  {0.525731f, 0.0f, 0.850651f}, {0.525731f, -4.93306e-08f, 0.850651f},
    {0.525731f, 5.7606e-08f, 0.850651f},
  {0.525731f, -5.7606e-08f, 0.850651f}, {1.42109e-15f, -0.850651f,
                                         -0.525731f}, {0.0f, -0.850651f,
                                                       -0.525731f},
  {-4.93306e-08f, -0.850651f, -0.525731f}, {5.75426e-08f, -0.850651f,
                                            -0.525731f}, {-5.75426e-08f,
                                                          -0.850651f,
                                                          -0.525731f},
  {4.93306e-08f, -0.850651f, -0.525731f}, {0.0f, 0.850651f, -0.525731f},
    {6.77345e-08f, 0.850651f, -0.525731f},
  {-2.26478e-08f, 0.850651f, -0.525731f}, {0.0f, 0.850651f, -0.525731f},
    {1.13239e-08f, 0.850651f, -0.525731f},
  {-2.25433e-08f, 0.850651f, -0.525731f}, {-6.77345e-08f, 0.850651f,
                                           -0.525731f}, {-0.525731f,
                                                         2.84217e-15f,
                                                         0.850651f},
  {-0.525731f, 8.62054e-08f, 0.850651f}, {-0.525731f, -6.40014e-08f,
                                          0.850651f}, {-0.525731f,
                                                       6.40014e-08f,
                                                       0.850651f},
  {-0.525731f, -8.62054e-08f, 0.850651f}, {-0.525731f, 0.0f, 0.850651f},
    {0.850651f, -0.525731f, 0.0f},
  {0.850651f, -0.525731f, -2.46653e-08f}, {0.850651f, -0.525731f,
                                           2.46653e-08f}, {0.850651f,
                                                           -0.525731f,
                                                           4.93306e-08f},
  {0.850651f, -0.525731f, -5.75426e-08f}, {0.850651f, -0.525731f,
                                           5.75426e-08f}, {0.850651f,
                                                           -0.525731f,
                                                           -4.93306e-08f},
  {-0.525731f, 2.84217e-15f, -0.850651f}, {-0.525731f, -6.36817e-08f,
                                           -0.850651f}, {-0.525731f,
                                                         8.62054e-08f,
                                                         -0.850651f},
  {-0.525731f, 0.0f, -0.850651f}, {-0.525731f, -8.62054e-08f, -0.850651f},
    {-0.525731f, 6.36817e-08f, -0.850651f},
  {0.850651f, 0.525731f, 0.0f}, {0.850651f, 0.525731f, 4.31027e-08f},
    {0.850651f, 0.525731f, -4.31027e-08f},
  {0.850651f, 0.525731f, -8.62054e-08f}, {0.850651f, 0.525731f, 1.70573e-07f},
    {0.850651f, 0.525731f, -1.70573e-07f},
  {0.850651f, 0.525731f, -4.21837e-08f}, {-0.850651f, -0.525731f, 0.0f},
    {-0.850651f, -0.525731f, 5.12061e-08f},
  {-0.850651f, -0.525731f, -2.16578e-08f}, {-0.850651f, -0.525731f, 0.0f},
    {-0.850651f, -0.525731f, 4.33157e-08f},
  {-0.850651f, -0.525731f, -1.45728e-07f}, {-0.850651f, -0.525731f,
                                            1.45728e-07f}
};
static GLfloat star_textures[21][2] = {
  {1.0f, 1.5f}, {0.595492f, 0.845492f}, {1.40451f, 0.845492f},
  {0.75f, 0.595492f}, {1.15451f, 1.25f}, {0.595492f, 1.15451f},
  {1.0f, 0.5f}, {1.40451f, 1.15451f}, {1.25f, 0.595492f},
  {0.845492f, 1.25f}, {0.845492f, 0.75f}, {1.25f, 1.40451f},
  {0.75f, 1.40451f}, {1.15451f, 0.75f}, {1.1382f, 1.0f},
  {0.138197f, 1.0f}, {0.25f, 0.595492f}, {0.25f, 1.40451f},
  {1.5f, 1.0f}, {0.861803f, 1.0f}, {0.5f, 1.0f}
};

GLint genListeStar()
{
  unsigned int i;
  int j;

  GLint lid = 0;

  lid = glGenLists(1);
  glNewList(lid, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  for (i = 0; i < sizeof(star_face_indicies) / sizeof(star_face_indicies[0]);
       i++)
  {

    for (j = 0; j < 3; j++)
    {
      int vi = star_face_indicies[i][j];
      int ni = star_face_indicies[i][j + 3]; // Normal index
      int ti = star_face_indicies[i][j + 6]; // Texture index

      glNormal3f(star_normals[ni][0], star_normals[ni][1],
                 star_normals[ni][2]);
      glTexCoord2f(star_textures[ti][0], star_textures[ti][1]);
      glVertex3f(star_vertices[vi][0], star_vertices[vi][1],
                 star_vertices[vi][2]);
    }
  }
  glEnd();

  glEndList();
  return lid;
};
