/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include "geom_bonus.h"

// 28 Verticies
// 37 Texture Coordinates
// 20 Normals
// 64 Triangles

static char ARROW_face_indicies[64][9] = {
// Cone01
	{0,2,1 ,0,1,1 ,0,1,2 }, {0,3,2 ,0,1,1 ,0,0,1 }, {0,4,3 ,0,1,1 ,0,3,0 },
	{0,5,4 ,0,1,1 ,0,4,3 }, {0,6,5 ,0,1,1 ,0,5,4 }, {0,7,6 ,0,0,1 ,6,7,8 },
	{0,8,7 ,0,1,0 ,0,9,7 }, {0,1,8 ,0,1,1 ,0,2,9 }, {1,9,9 ,1,2,2 ,2,10,10 },
	{1,2,9 ,3,3,3 ,2,1,10 }, {2,9,9 ,1,2,2 ,1,10,10 }, {2,3,9 ,4,4,4 ,1,0,10 },
	{3,9,9 ,1,2,2 ,0,10,10 }, {3,4,9 ,5,5,5 ,0,3,10 }, {4,9,9 ,1,2,2 ,3,10,10 },
	{4,5,9 ,6,6,6 ,3,4,10 }, {5,9,9 ,1,2,2 ,4,10,10 }, {5,6,9 ,7,7,7 ,4,5,10 },
	{6,9,9 ,1,2,2 ,5,10,10 }, {6,7,9 ,8,8,8 ,8,7,11 }, {7,9,9 ,2,2,2 ,7,10,10 },
	{7,8,9 ,9,9,9 ,7,9,10 }, {8,9,9 ,1,2,2 ,9,10,10 }, {8,1,9 ,10,10,10 ,9,2,10 },
	{9,9,9 ,2,2,2 ,12,12,12 }, {9,9,9 ,2,2,2 ,12,12,12 }, {9,9,9 ,2,2,2 ,12,12,12 },
	{9,9,9 ,2,2,2 ,12,12,12 }, {9,9,9 ,2,2,2 ,12,12,12 }, {9,9,9 ,2,2,2 ,12,12,12 },
	{9,9,9 ,2,2,2 ,12,12,12 }, {9,9,9 ,2,2,2 ,12,12,12 }
// Cylinder01
	, {10,12,11 ,11,11,11 ,0,13,2 }, {10,13,12 ,11,11,11 ,6,14,13 },
	{10,14,13 ,11,11,11 ,0,15,16 }, {10,15,14 ,11,11,11 ,0,17,15 },
	{10,16,15 ,11,11,11 ,0,18,17 }, {10,17,16 ,11,11,11 ,0,0,18 },
	{10,18,17 ,11,11,11 ,0,1,0 }, {10,11,18 ,11,11,11 ,0,2,1 }, {11,20,19 ,12,12,12 ,2,19,20 },
	{11,12,20 ,12,12,12 ,2,13,19 }, {12,21,20 ,13,13,13 ,13,21,19 },
	{12,13,21 ,13,13,13 ,13,14,21 }, {13,22,21 ,14,14,14 ,16,22,23 },
	{13,14,22 ,14,14,14 ,16,15,22 }, {14,23,22 ,15,15,15 ,15,24,22 },
	{14,15,23 ,15,15,15 ,15,17,24 }, {15,24,23 ,16,16,16 ,17,25,24 },
	{15,16,24 ,16,16,16 ,17,18,25 }, {16,25,24 ,17,17,17 ,18,10,25 },
	{16,17,25 ,17,17,17 ,18,0,10 }, {17,26,25 ,18,18,18 ,0,26,10 },
	{17,18,26 ,18,18,18 ,0,1,26 }, {18,19,26 ,19,19,19 ,1,20,26 },
	{18,11,19 ,19,19,19 ,1,2,20 }, {27,19,20 ,0,0,0 ,12,27,28 },
	{27,20,21 ,0,0,0 ,29,30,31 }, {27,21,22 ,0,0,0 ,12,32,33 }, {27,22,23 ,0,0,0 ,12,33,34 },
	{27,23,24 ,0,0,0 ,12,34,35 }, {27,24,25 ,0,0,0 ,12,35,12 }, {27,25,26 ,0,0,0 ,12,12,36 },
	{27,26,19 ,0,0,0 ,12,36,27 }
};
static GLfloat ARROW_vertices [28][3] = {
{0.0f,0.0f,-0.115385f},{0.307692f,0.0f,-0.115385f},{0.217571f,-0.217571f,-0.115385f},
{-1.34684e-08f,-0.307692f,-0.115385f},{-0.217571f,-0.217571f,-0.115385f},{-0.307692f,2.69367e-08f,-0.115385f},
{-0.217571f,0.217571f,-0.115385f},{4.03478e-08f,0.307692f,-0.115385f},{0.217571f,0.217571f,-0.115385f},
{0.0f,0.0f,-0.5f},{-0.00228518f,-0.00156837f,-0.115385f},{0.0900225f,-0.00156837f,-0.115385f},
{0.0629862f,0.063703f,-0.115385f},{-0.00228518f,0.0907393f,-0.115385f},{-0.0675566f,0.063703f,-0.115385f},
{-0.0945929f,-0.00156838f,-0.115385f},{-0.0675566f,-0.0668398f,-0.115385f},{-0.00228517f,-0.0938761f,-0.115385f},
{0.0629862f,-0.0668398f,-0.115385f},{0.0900225f,-0.00156837f,0.5f},{0.0629862f,0.063703f,0.5f},
{-0.00228518f,0.0907393f,0.5f},{-0.0675566f,0.063703f,0.5f},{-0.0945929f,-0.00156838f,0.5f},
{-0.0675566f,-0.0668398f,0.5f},{-0.00228517f,-0.0938761f,0.5f},{0.0629862f,-0.0668398f,0.5f},
{-0.00228518f,-0.00156837f,0.5f}
};
static GLfloat ARROW_normals [20][3] = {
{0.0f,0.0f,1.0f},{0.301511f,0.301511f,0.904534f},{0.57735f,0.57735f,0.57735f},
{0.742971f,-0.307749f,-0.594377f},{0.307749f,-0.742971f,-0.594377f},{-0.307749f,-0.742971f,-0.594377f},
{-0.742971f,-0.307749f,-0.594377f},{-0.742971f,0.307749f,-0.594377f},{-0.307749f,0.742971f,-0.594377f},
{0.307749f,0.742971f,-0.594377f},{0.742971f,0.307749f,-0.594377f},{0.0f,0.0f,-1.0f},
{0.92388f,0.382683f,0.0f},{0.382683f,0.92388f,0.0f},{-0.382683f,0.92388f,0.0f},
{-0.92388f,0.382683f,0.0f},{-0.923879f,-0.382684f,0.0f},{-0.382683f,-0.92388f,0.0f},
{0.382684f,-0.92388f,0.0f},{0.92388f,-0.382683f,0.0f}
};
static GLfloat ARROW_textures [37][2] = {
{0.5f,1.0f},{0.625f,1.0f},{0.75f,1.0f},
{0.375f,1.0f},{0.25f,1.0f},{0.125f,1.0f},
{1.5f,1.0f},{1.0f,1.0f},{1.125f,1.0f},
{0.875f,1.0f},{0.5f,2.0f},{1.5f,2.0f},
{0.5f,0.0f},{0.875f,1.0f},{1.0f,1.0f},
{0.125f,1.0f},{2.78275e-08f,1.0f},{0.25f,1.0f},
{0.375f,1.0f},{0.875f,2.0f},{0.75f,2.0f},
{1.0f,2.0f},{0.125f,2.0f},{2.78275e-08f,2.0f},
{0.25f,2.0f},{0.375f,2.0f},{0.625f,2.0f},
{0.75f,0.0f},{0.875f,0.0f},{1.5f,0.0f},
{0.875f,0.0f},{1.0f,0.0f},{2.78275e-08f,0.0f},
{0.125f,0.0f},{0.25f,0.0f},{0.375f,0.0f},
{0.625f,0.0f}
};

GLint genListeBigArrow()
{
  unsigned int i;
  int j;

  GLint lid = 0;

  lid = glGenLists(1);

  glNewList(lid, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  for (i = 0; i < sizeof(ARROW_face_indicies) / sizeof(ARROW_face_indicies[0]); i++)
  {

    for (j = 0; j < 3; j++)
    {
      int vi = ARROW_face_indicies[i][j];
      int ni = ARROW_face_indicies[i][j + 3]; // Normal index
      int ti = ARROW_face_indicies[i][j + 6]; // Texture index

      glNormal3f(ARROW_normals[ni][0], ARROW_normals[ni][1], ARROW_normals[ni][2]);
      glTexCoord2f(ARROW_textures[ti][0], ARROW_textures[ti][1]);
      glVertex3f(ARROW_vertices[vi][0], ARROW_vertices[vi][1], ARROW_vertices[vi][2]);
    }
  }
  glEnd();

  glEndList();
  return lid;
};
