/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"
#include "file_utils.h"
#include "map_seeking.h"
#include "menus.h"
#include "sounds.h"
#include "game_loop.h"

#define INGAME_ARROW_X 285

#define INGAME_RESUME_Y 215
#define INGAME_RESTARTMAP_Y 255
#define INGAME_OPTIONS_Y 295
#define INGAME_EXITMAP_Y 335
#define INGAME_QUITGAME_Y 375

#define INGAME_RESUME 0
#define INGAME_RESTARTMAP 1
#define INGAME_OPTIONS 2
#define INGAME_EXITMAP 3
#define INGAME_QUITGAME 4

#define INGAME_MENU_W 256
#define INGAME_MENU_H 256
#define INGAME_MENU_X 250
#define INGAME_MENU_Y 150

extern player_t *player;
extern game_data_t *world;
extern map_names_t *map_names;
extern char *filename;

extern menu_common_t *menu_shared;
extern main_menu_t *main_menu;
extern skirmish_menu_t *sk_menu;

ingame_menu_t *menu_ingame;

const char *i_ingame_menu = SHXMAN_DATA "menus/ingame/ingame.png";
const char *i_ingame_menu_m = SHXMAN_DATA "menus/ingame/ingame_mask.png";
const char *i_ingame_arrow = SHXMAN_DATA "menus/ingame/arrow_ingame.png";

extern int mouse_rel_x;
extern int mouse_rel_y;

void load_menu_ingame()
{
  menu_ingame = new ingame_menu_t;
  LoadTexture(i_ingame_menu, &menu_ingame->tex_menu);
  LoadTexture(i_ingame_menu_m, &menu_ingame->tex_menu_mask);
  LoadTexture(i_ingame_arrow, &menu_ingame->tex_menu_arrow);

  menu_ingame->selected_submenu = INGAME_RESUME;
}

void cleanup_menu_ingame()
{
  glDeleteTextures(1, &menu_ingame->tex_menu);
  glDeleteTextures(1, &menu_ingame->tex_menu_mask);
  glDeleteTextures(1, &menu_ingame->tex_menu_arrow);
}


void draw_ingame_menu()
{
  /* first we draw static elements of the menu */
  draw_ingame_menu_static();

  /* draw lighted elements on mouse-over */
  draw_ingame_menu_mouseover();

  /* then we draw the cursor */
  draw_cursor();
}

void analyze_ingame_menu_buttondown(int *loop_flag)
{
  switch (menu_ingame->selected_submenu)
    {
    case INGAME_RESUME:
      play_menu_sound(MENU_SOUND_OK);
      *loop_flag=1;
      break;

    case INGAME_OPTIONS:
      play_menu_sound(MENU_SOUND_OK);
      /* game is already paused */
      options_menu_loop(1);
      SDL_GetRelativeMouseState(&mouse_rel_x,&mouse_rel_y);
      break;

    case INGAME_EXITMAP:
      play_menu_sound(MENU_SOUND_OK);
      *loop_flag=1;
      world->gameEnd=1;
      break;   

    case INGAME_QUITGAME:
      *loop_flag=1;
      world->gameEnd=1;
      sk_menu->loop_end=1;
      main_menu->loop_end=1;
      break;

    case INGAME_RESTARTMAP:
      play_menu_sound(MENU_SOUND_OK);
      *loop_flag=1;
      world->gameEnd=1;

      unpause_game();
      world->game_paused = 0;

      world->need_to_restart_map=1;
      break;

    default: break;
    }
}

void draw_ingame_menu_static()
{
  glEnable(GL_BLEND);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);
  glBindTexture(GL_TEXTURE_2D, menu_ingame->tex_menu_mask);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(INGAME_MENU_X, INGAME_MENU_Y);
  glTexCoord2f(1, 0);
  glVertex2f(INGAME_MENU_X+INGAME_MENU_W, INGAME_MENU_Y);
  glTexCoord2f(1, 1);
  glVertex2f(INGAME_MENU_X+INGAME_MENU_W, INGAME_MENU_Y+INGAME_MENU_H);
  glTexCoord2f(0, 1);
  glVertex2f(INGAME_MENU_X, INGAME_MENU_Y+INGAME_MENU_H);
  glEnd();

  glBlendFunc(GL_ONE, GL_ONE);

  glBindTexture(GL_TEXTURE_2D, menu_ingame->tex_menu);
  
  glBegin(GL_QUADS);
  glTexCoord2f(0, 0);
  glVertex2f(INGAME_MENU_X, INGAME_MENU_Y);
  glTexCoord2f(1, 0);
  glVertex2f(INGAME_MENU_X+INGAME_MENU_W, INGAME_MENU_Y);
  glTexCoord2f(1, 1);
  glVertex2f(INGAME_MENU_X+INGAME_MENU_W, INGAME_MENU_Y+INGAME_MENU_H);
  glTexCoord2f(0, 1);
  glVertex2f(INGAME_MENU_X, INGAME_MENU_Y+INGAME_MENU_H);

  glEnd();
}

void draw_ingame_menu_mouseover()
{
  draw_ingame_menu_big_arrow();  
}

void analyze_ingame_menu_hoover()
{
  if ((menu_shared->mouse_x >= INGAME_MENU_X) && (menu_shared->mouse_x < (INGAME_MENU_X+INGAME_MENU_H)))
  {

    if( (menu_shared->mouse_y >= INGAME_MENU_Y) && (menu_shared->mouse_y < (INGAME_RESUME_Y+20)))
      {
	menu_ingame->old_selected_submenu = menu_ingame->selected_submenu;
	menu_ingame->selected_submenu = INGAME_RESUME;
      }

    else if ((menu_shared->mouse_y >=(INGAME_OPTIONS_Y-20)) && (menu_shared->mouse_y < (INGAME_OPTIONS_Y+20)))
      {
	menu_ingame->old_selected_submenu = menu_ingame->selected_submenu;
	menu_ingame->selected_submenu = INGAME_OPTIONS;
      }

    else if ((menu_shared->mouse_y >= (INGAME_EXITMAP_Y-20)) && (menu_shared->mouse_y < (INGAME_EXITMAP_Y+20)))
      {
	menu_ingame->old_selected_submenu =menu_ingame-> selected_submenu;
	menu_ingame->selected_submenu = INGAME_EXITMAP;
      }

    else if ((menu_shared->mouse_y >= (INGAME_QUITGAME_Y-20)) && (menu_shared->mouse_y < (INGAME_QUITGAME_Y+20)))
      {
	menu_ingame->old_selected_submenu = menu_ingame->selected_submenu;
	menu_ingame->selected_submenu = INGAME_QUITGAME;
      }

    else if ((menu_shared->mouse_y >= (INGAME_RESTARTMAP_Y-20)) && (menu_shared->mouse_y < (INGAME_RESTARTMAP_Y+20)))
      {
	menu_ingame->old_selected_submenu = menu_ingame->selected_submenu;
	menu_ingame->selected_submenu = INGAME_RESTARTMAP;
      }

  }
      if ((menu_ingame->old_selected_submenu >= 0) && (menu_ingame->old_selected_submenu != menu_ingame->selected_submenu))
  {
    play_menu_sound(MENU_SOUND_SELECT_SUBMENU);
    menu_ingame->old_selected_submenu=menu_ingame->selected_submenu;
  }
} 

void ingame_menu_loop()
{
  int loop_end = 0;
  menu_shared->is_button_down=0;

  while (!(loop_end))
  {
    world->game_sync->update_temps();
    world->game_timer->update_temps();
    update_bonus();
    
    {
      SDL_Event event;
      
      while (SDL_PollEvent(&event))
	{
	  if (event.type == SDL_KEYDOWN)
	    {
	      switch (event.key.keysym.sym)
		{
		 case SDLK_ESCAPE:
 		  loop_end = 1;
 		  break;
		  
		default:
		  break;
		}
	    }
	  
	  if (event.type == SDL_KEYDOWN)
	    {
	      
	      switch (event.key.keysym.sym)
		{
		case SDLK_DOWN:
		  menu_shared->lock_mouse=1;
		  menu_ingame->old_selected_submenu = menu_ingame->selected_submenu;
		  if (menu_ingame->selected_submenu < 3) 
		    menu_ingame->selected_submenu++;
		  else menu_ingame->selected_submenu=0;
		  break;

		case SDLK_UP:
		  menu_shared->lock_mouse=1;
		  menu_ingame->old_selected_submenu = menu_ingame->selected_submenu;
		  if (menu_ingame->selected_submenu > 0) 
		    menu_ingame->selected_submenu--;
		  else menu_ingame->selected_submenu=3;
		  break;

		case SDLK_RETURN:
		  analyze_ingame_menu_buttondown(&loop_end);
		  break;

		default: break;
		}
	    }

	  if (event.type == SDL_MOUSEMOTION)
	    {
	      menu_shared->lock_mouse=0;
	      menu_ingame->old_selected_submenu=menu_ingame->selected_submenu;
	    }

	  if (event.type == SDL_MOUSEBUTTONDOWN)
	    {
	      menu_shared->is_button_down=1;
	    }

	  if (event.type == SDL_MOUSEBUTTONUP)
	    {
	      menu_shared->is_button_down=0;
	    }
	}
    }

    SDL_GetMouseState(&menu_shared->mouse_x,&menu_shared->mouse_y);
    if (menu_shared->is_button_down)
      analyze_ingame_menu_buttondown(&loop_end);

    if (menu_shared->lock_mouse == 0)
      analyze_ingame_menu_hoover();

    draw_entire_scene_GL();

  }
  SDL_GetRelativeMouseState(&mouse_rel_x,&mouse_rel_y);
}

void draw_ingame_menu_big_arrow()
{
  GLfloat x=0, y=0;

  x=INGAME_ARROW_X;
  switch (menu_ingame->selected_submenu)
    {
    case INGAME_RESUME:
      y= INGAME_RESUME_Y;
      break;

    case INGAME_RESTARTMAP:
      y= INGAME_RESTARTMAP_Y;
      break;

    case INGAME_OPTIONS:
      y=INGAME_OPTIONS_Y;
      break;

    case INGAME_EXITMAP:
      y=INGAME_EXITMAP_Y;
      break;   

    case INGAME_QUITGAME:
      y=INGAME_QUITGAME_Y;
      break;

    default: 
      y=INGAME_RESUME_Y;
      break;
    }
  glPushMatrix();
  
  glEnable(GL_BLEND);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);
  
  glBindTexture(GL_TEXTURE_2D, main_menu->tex_dyn_menu[1]);
  glBegin(GL_QUADS);

#define ARROW_SIZE 38
   
  glTexCoord2f(0, 1);
  glVertex2f(x, 600-y);
  glTexCoord2f(0, 0);
  glVertex2f(x, 600-(y+ARROW_SIZE));
  glTexCoord2f(1, 0);
  glVertex2f(x+ARROW_SIZE, 600-(y+ARROW_SIZE));
  glTexCoord2f(1, 1);
  glVertex2f(x+ARROW_SIZE, 600-y);
  
  glEnd();
  
  glBlendFunc(GL_ONE, GL_ONE);
  
  glBindTexture(GL_TEXTURE_2D, menu_ingame->tex_menu_arrow);
  glBegin(GL_QUADS);
  
  glTexCoord2f(0, 1);
  glVertex2f(x, 600-y);
  glTexCoord2f(0, 0);
  glVertex2f(x, 600-(y+ARROW_SIZE));
  glTexCoord2f(1, 0);
  glVertex2f(x+ARROW_SIZE, 600-(y+ARROW_SIZE));
  glTexCoord2f(1, 1);
  glVertex2f(x+ARROW_SIZE, 600-y);
  
  glEnd();
  
  glEnd();
  
  glDisable(GL_BLEND);
  glPopMatrix();
}
