/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include <SDL/SDL.h>

#include "timers.h"

TEMPS::TEMPS()
{
  t_courant = 0;
  t_precedent = 0;
  t_zero = 0;
  dt = 0;
  nombre_cycles = 0;
  somme_dt = 0;

}

SYNCHRONIZER::SYNCHRONIZER()
{
  fpsInstant = 0;
  fps_min = 0;
  fps_max = 0;
  moyenneFps = 0;
  nombreMoyenne = 0;

}

TEMPS::~TEMPS()
{

}

SYNCHRONIZER::~SYNCHRONIZER()
{

}

CHRONOMETRE::CHRONOMETRE()
{
  chrono.minutes = 0;
  chrono.secondes = 0;
  restant.minutes=0; restant.secondes=0;
  paused=0; t_pause=0; t_pause_total=0;
  t_restant=0; t_limite=0;
}

CHRONOMETRE::~CHRONOMETRE()
{
}

void TEMPS::initialise()
{
  t_zero = SDL_GetTicks();
  t_courant = t_zero;
  nombre_cycles = 0;
}

void CHRONOMETRE::resetTemps()
{
  initialise();

  paused=0; t_pause=0; t_pause_total=0;
  t_restant=0; t_limite=0;
  chrono.minutes = 0;
  chrono.secondes = 0;
  if (t_limite) {
    t_restant = t_limite-t_courant;
    restant.minutes = (int)floor( (t_restant/1000) / 60);
    restant.secondes = (t_restant/1000) % 60;
  }
}


void CHRONOMETRE::togglePaused()
{
  int balnave = 0;

  if (!(paused))
  {
    paused = 1;
    balnave = 1;
    t_pause = 0;

    pause_date = SDL_GetTicks();
  }

  if ((paused) && (!(balnave)))
  {
    paused = 0;
    t_pause_total += t_pause;
  }

  
}

void CHRONOMETRE::setAlarm(int totalTime)
{
  t_limite = (totalTime)*1000;
}

char CHRONOMETRE::update_temps()
{
  if (paused) t_pause = SDL_GetTicks() - pause_date;
  else t_courant = SDL_GetTicks() - (t_zero+t_pause_total);
  
  chrono.secondes = (int) floor(t_courant / 1000) - chrono.minutes * 60;
  if (chrono.secondes == 60)
  {
    chrono.minutes++;
    chrono.secondes = 0;
  }

  if (t_limite) {
    t_restant = t_limite-t_courant;
    if (t_restant <= 0) return 1;
    restant.minutes = (int)floor( (t_restant/1000) / 60);
    restant.secondes = (t_restant/1000) % 60;
  }

  return 0;
}

void TEMPS::update_temps()
{
  t_precedent = t_courant;
  t_courant = SDL_GetTicks() - t_zero;
  dt = t_courant - t_precedent;
  nombre_cycles++;

  if (nombre_cycles < 11)
  {
    somme_dt += dt;
  }
}

int SYNCHRONIZER::update_temps()
{
  t_precedent = t_courant;
  t_courant = SDL_GetTicks() - t_zero;
  dt = t_courant - t_precedent;
  nombre_cycles++;

  // we get FPS all cycles
  if (nombre_cycles < 11)
  {
    somme_dt += dt;
  }
  // and we take a medium value on all 10 cycles
  else
  {
    if (somme_dt) fpsInstant = 10000 / somme_dt;
    else fpsInstant = 666;
    nombre_cycles = 0;
    somme_dt = 0;

    if (fpsInstant > fps_max)
      fps_max = fpsInstant;
    if ((fpsInstant < fps_min) || (fps_min <= 0))
      fps_min = fpsInstant;
    if (moyenneFps == 0)
      moyenneFps = fpsInstant;
    calculeMoyenne();
  }

  return fpsInstant;
}

void SYNCHRONIZER::calculeMoyenne()
{
  nombreMoyenne++;

  moyenneFps =
    moyenneFps * (nombreMoyenne / (nombreMoyenne + 1)) +
    (double) fpsInstant / (nombreMoyenne + 1);
}
