/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TEMPS_H
#define TEMPS_H

struct UNITE_TEMPS
{
  int minutes;
  int secondes;
};

class TEMPS
{
public:
  TEMPS ();
  ~TEMPS ();
  void initialise ();
  void update_temps ();

  int dt;
 
protected:
  int t_courant;
  int t_precedent;
  int t_zero;

  int somme_dt;
  int nombre_cycles;
};


class SYNCHRONIZER : public TEMPS
{
 public:
  SYNCHRONIZER ();
  ~SYNCHRONIZER ();

  int update_temps();

  int getFpsMin() 
    {
      return fps_min;
    }
  
  int getFpsMax()
    {
      return fps_max;
    }

  double getMoyenneFps()
    {
      return moyenneFps;
    }
	 
  int getFpsInstant() 
    {
      return fpsInstant;
    }

private:
  int fps_min;
  int fps_max;
  double moyenneFps;
  double nombreMoyenne;
  int fpsInstant;

  void calculeMoyenne();
};

class CHRONOMETRE : public TEMPS
{
public:
  CHRONOMETRE();
  ~CHRONOMETRE();

  char update_temps();

  int getSecondes()
  {
    return chrono.secondes;
  }

  int getMinutes()
  {
    return chrono.minutes;
  }

  int getCourant()
  {
    return t_courant;
  }

  void setAlarm(int totalTime);

  int getRestMin()
  {
    return restant.minutes;
  }

  int getRestSec()
  {
    return restant.secondes;
  }

  void resetTemps();

  void togglePaused();



private:
  UNITE_TEMPS chrono;
  UNITE_TEMPS restant;
  int t_restant;
  int t_limite;

  int t_pause;
  int t_pause_total;

  int pause_date;
  char paused;
};

#endif
