//
//  Starter_Banks.h
//
//
//  Created by Pierre Peterlongo on 25/10/2012
//
#include <vector>
#include "Starter.h"
#include "Extension_Bank.h"
#include "BooleanVector.h"

extern "C"{
    //#include "read_coherence_mapsembler/simplehash.h"
#include "read_coherence_mapsembler/list.h"
#include "read_coherence_mapsembler/hash.h"
}
#include "commons.h"
#include "Fragment_Bank.h"
#include "../minia/Bank.h"


#ifndef _STARTER_BANK_H
#define _STARTER_BANK_H


class Starter_Bank{
    vector<Starter *> starter_bank;
public:
    Starter_Bank(Fragment_Bank *fragment_bank);
    ~Starter_Bank();
    Extension_Bank * generate_all_substarters(const int min_coverage, const int substitutions_allowed, const int error_threshold, const int size_kmers);
    Extension_Bank * generate_all_substarter_nomapping(const int size_kmers);
    void  format_results(const int extension_type, Extension_Bank * extension_bank, string prefix_name);
    /**
     * Map a set of reads from files (managed in Bank) on fragments
     */
    void map_reads(Bank * reads, const int substitutions_allowed);
    
};
#endif //_STARTER_BANK_H
