%define version 0.3.3
%define rel 1
%define prefix /usr/local

Summary: C Masq Dialer deamon.
Name: c-mserver
Version: %version
Release: %rel 
Copyright: GPL
Group: Networking/Daemons
Vendor: Chares P. Wright <cpwright@cpwright.com>
Packager: Nick 'Zaf' Clifford <zaf@nrc.co.nz>
Source: ftp.cpwright.com:/pub/mserver/c-mserver-%{version}.tar.gz
BuildRoot: /tmp/c-mserver-%{version}
# Patch: c-mserver-0.1.0-makefile.patch

%description
The masqdialer system will allow authorized LAN users to manipulate
the network interface (usually a modem) that gives the internet
access on a Linux box without having to use telnet. Its based on
a client/server approach so any TCP/IP enabled system should be able
to take advantage of this server, if a client is written for it.
Currently; Linux, Windows, NetBSD, and any system with a Java
implementation or Web Browser have clients.

%prep
%setup -q -n mserver-%{version}
# %patch -p1

%build
make
cd docs
make

%install
rm -rf $RPM_BUILD_ROOT
install -d -m 755 $RPM_BUILD_ROOT%{prefix}/sbin
install -m 755 -s mserver/mserver $RPM_BUILD_ROOT%{prefix}/sbin/mserver
install -m 755 -s mchat/mchat $RPM_BUILD_ROOT%{prefix}/sbin/mchat
install -m 755 -s authgen/authgen $RPM_BUILD_ROOT%{prefix}/sbin/authgen
# install -m 755 -s checkstat/checkstat $RPM_BUILD_ROOT%{prefix}/sbin/checkstat

install -d -m 755 $RPM_BUILD_ROOT%{prefix}/doc/mserver-%version/
install -m 644 LICENSE $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/
install -m 644 HISTORY $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/
install -m 644 mserver/PROTOCOL $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/

install -m 644 README $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/
install -m 644 HISTORY $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/
install -m 644 LICENSE $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/	
install -m 644 docs/index.html $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/
install -d -m 755 $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/images/
install -m 644 docs/images/*.* $RPM_BUILD_ROOT%{prefix}/doc/mserver-%{version}/images/
install -d -m 755 $RPM_BUILD_ROOT/etc/rc.d/init.d/
install -m 755 initscripts/mserver $RPM_BUILD_ROOT/etc/rc.d/init.d/
install -m 644 mserver/mserver.conf $RPM_BUILD_ROOT/etc/
install -d -m 755 $RPM_BUILD_ROOT%{prefix}/man/man8/
install -m 644 mchat/mchat.8 $RPM_BUILD_ROOT%{prefix}/man/man8/

%files
/etc/mserver.conf
/etc/rc.d/init.d/mserver
%{prefix}/doc/mserver-%{version}/*
%{prefix}/sbin/mserver
%{prefix}/sbin/mchat
%{prefix}/sbin/authgen
# %{prefix}/sbin/checkstat
%{prefix}/man/man8/mchat.8


