/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _THEME_H_
#define _THEME_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/xpm.h>

#include <X11/cursorfont.h>

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "structs.h"
#include "wm.h"
#include "misc.h"
#include "main_client.h"
#include "docked_client.h"
#include "toolbar_client.h"
#include "dockbar_client.h"

#include "rcfile.h"

/* OLD */

#define COL_FG       "white"
#define COL_BG       "steelblue"
#define COL_BD       "black"

#define COL_SHADE  "50:50:50"

#define BUTTON_SPACING 2
#define XPM_PREV       "img/prev.xpm"
#define XPM_PREV_DOWN  "todo"
#define XPM_NEXT       "img/next.xpm"
#define XPM_NEXT_DOWN  "todo"
#define XPM_CLOSE      "img/close.xpm"
#define XPM_CLOSE_DOWN "todo"
#define XPM_TOOLBAR    "img/toolbar.xpm"
#define XPM_TOOLBAR_CLOSE "img/toolbar_close.xpm"
#define XPM_MENU_SELECT "img/toolbar_close.xpm"
#define XPM_TILE       "img/gpe_toolbar2.xpm"

/* NEW */

#define BUTTON_NEXT    0
#define BUTTON_PREV    1
#define BUTTON_CLOSE   2
#define BUTTON_TOOLBAR 3
#define BUTTON_TOOLBAR_CLOSE 4
#define BUTTON_MENU_SELECT   5


Theme* theme_new(wm *w, char *theme_conf);
int theme_load(wm *w, Theme *t, char *theme_conf);
void theme_switch(wm *w, Theme *t, char *new_theme_conf);
void theme_load_pixmap(Wm *w, char *filename, Pixmap *pxm, Pixmap *mask,
		       int *width, int *height );

int theme_load_pxm(Wm *w, char *filename, Pxm *pxm );
void theme_paint_pxm(wm *w, Drawable dest, int x, int y, Pxm *p);


void
theme_render_area(wm *w, Drawable dest, int x, int y,
		  int width, int height );

void theme_draw_gradient(wm *w, Drawable dest, GC gc, int x, int y,
			 int width, int height, 
			 XColor* start_col, XColor* end_col);
int
_XColorFromStr(Display *display, XColor *col, const char *defstr);
#endif
